/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.installation;

import com.ur.polyscope.gripper.internal.gripper.GripperContext;
import com.ur.polyscope.tcp.TCPService;
import com.ur.polyscope.tcp.urcap.TCPContributed;
import com.ur.polyscope.tcp.urcap.TcpConfigurationFactory;
import com.ur.urcap.api.contribution.driver.general.tcp.TCPConfiguration;
import com.ur.urcap.api.domain.tcp.TCP;
import com.ur.urcap.api.domain.value.Pose;

public class GripperMigrationHandler {
    private final TcpConfigurationFactory tcpConfigurationFactory;
    private final TCPContributed tcpContributed;
    private final TCPService tcpService;
    private final Class contributionClass;

    public GripperMigrationHandler(Class contributionClass, TcpConfigurationFactory tcpConfigurationFactory, TCPContributed tcpContributed, TCPService tcpService) {
        this.tcpConfigurationFactory = tcpConfigurationFactory;
        this.tcpContributed = tcpContributed;
        this.tcpService = tcpService;
        this.contributionClass = contributionClass;
    }

    public void migrateFromSingleToMulti(GripperContext gripperContext) {
        if (gripperContext.isMultiGripper()) {
            this.migrateTCPFromSingleGripper();
        }
    }

    private void migrateTCPFromSingleGripper() {
        TCPConfiguration singleGripperTCPConfiguration = this.tcpConfigurationFactory.createTCPConfiguration(this.contributionClass, "");
        TCP singleGripperTCP = singleGripperTCPConfiguration.getTCP();
        if (singleGripperTCP != null) {
            if (singleGripperTCP.isResolvable()) {
                Pose offset = singleGripperTCP.getOffset();
                this.forceRemoveTCP(singleGripperTCPConfiguration);
                this.tcpContributed.addTCP(singleGripperTCP.getDisplayName(), offset);
            } else {
                this.forceRemoveTCP(singleGripperTCPConfiguration);
            }
        }
    }

    private void forceRemoveTCP(TCPConfiguration singleGripperTCPConfiguration) {
        boolean allowed = this.tcpService.isTCPRemoveAndUpdateAllowed();
        try {
            this.tcpService.setTCPRemoveAndUpdateAllowed(true);
            singleGripperTCPConfiguration.removeTCP();
        }
        finally {
            this.tcpService.setTCPRemoveAndUpdateAllowed(allowed);
        }
    }
}

