/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.installation;

import com.ur.polyscope.gripper.internal.gripper.AbstractProxiedService;
import com.ur.polyscope.gripper.internal.gripper.ContributionConfigurationImpl;
import com.ur.polyscope.gripper.internal.gripper.GripperCapabilitiesImpl;
import com.ur.polyscope.gripper.internal.gripper.GripperContext;
import com.ur.polyscope.gripper.internal.gripper.GripperFeedbackCapabilitiesImpl;
import com.ur.polyscope.gripper.internal.gripper.installation.FeedbackPreambleGenerator;
import com.ur.polyscope.gripper.internal.gripper.installation.GripperAPIProviderImpl;
import com.ur.polyscope.gripper.internal.gripper.installation.GripperConfigurationImpl;
import com.ur.polyscope.gripper.internal.gripper.installation.InstallationDefined;
import com.ur.polyscope.gripper.internal.gripper.installation.InstallationValid;
import com.ur.polyscope.gripper.internal.gripper.installation.ProxyCustomUserInputConfiguration;
import com.ur.polyscope.gripper.internal.gripper.installation.ProxyGripperInstallationNodeService$AjcClosure1;
import com.ur.polyscope.gripper.internal.gripper.installation.ProxyGripperInstallationNodeService$AjcClosure3;
import com.ur.polyscope.gripper.internal.gripper.installation.ProxyGripperInstallationNodeService$AjcClosure5;
import com.ur.polyscope.gripper.internal.gripper.installation.ProxyGripperInstallationNodeService$AjcClosure7;
import com.ur.polyscope.gripper.internal.gripper.installation.SystemConfigurationImpl;
import com.ur.polyscope.gripper.internal.resources.ImageResource;
import com.ur.polyscope.installation.urcap.proxy.DataModelResetable;
import com.ur.polyscope.installation.urcap.proxy.Defined;
import com.ur.polyscope.installation.urcap.proxy.DriverNodeBuilder;
import com.ur.polyscope.installation.urcap.proxy.PreambleGeneratorService;
import com.ur.polyscope.installation.urcap.proxy.Updatable;
import com.ur.polyscope.tcp.urcap.TcpConfigurationFactory;
import com.ur.polyscope.urcaps.exception.ProxiedException;
import com.ur.polyscope.valueobjects.aspects.UncaughtExceptionAspect;
import com.ur.urcap.api.contribution.InstallationNodeContribution;
import com.ur.urcap.api.contribution.ViewAPIProvider;
import com.ur.urcap.api.contribution.driver.general.tcp.TCPConfiguration;
import com.ur.urcap.api.contribution.driver.general.userinput.CustomUserInputConfiguration;
import com.ur.urcap.api.contribution.driver.gripper.GripperAPIProvider;
import com.ur.urcap.api.contribution.driver.gripper.GripperConfiguration;
import com.ur.urcap.api.contribution.driver.gripper.GripperContribution;
import com.ur.urcap.api.contribution.driver.gripper.SystemConfiguration;
import com.ur.urcap.api.contribution.installation.ContributionConfiguration;
import com.ur.urcap.api.contribution.installation.CreationContext;
import com.ur.urcap.api.contribution.installation.InstallationAPIProvider;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeService;
import com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeView;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.script.ScriptWriter;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.ImageIcon;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ProxyGripperInstallationNodeService
extends AbstractProxiedService
implements SwingInstallationNodeService,
DataModelResetable {
    private static Provider<GripperCapabilitiesImpl> gripperCapabilitiesProvider;
    private final DriverNodeBuilder builder;
    private final GripperContribution service;
    private final GripperContext gripperContext;
    private String title = null;
    private final InstallationValid installationValid;
    private final ContributionConfigurationImpl contributionConfiguration;
    private RuntimeException exceptionThrownDuringCreate;
    private CustomUserInputConfiguration customConfiguration;
    private static TcpConfigurationFactory tcpConfigurationFactory;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    public ProxyGripperInstallationNodeService(DriverNodeBuilder builder, GripperContribution service, GripperContext gripperContext, InstallationValid installationValid, ContributionConfigurationImpl contributionConfiguration, RuntimeException exceptionThrownDuringCreate) {
        super(service.getClass());
        this.builder = builder;
        this.service = service;
        this.gripperContext = gripperContext;
        this.installationValid = installationValid;
        this.contributionConfiguration = contributionConfiguration;
        this.exceptionThrownDuringCreate = exceptionThrownDuringCreate;
    }

    @Inject
    public static void setGripperCapabilitiesProvider(Provider<GripperCapabilitiesImpl> gripperCapabilitiesProvider) {
        ProxyGripperInstallationNodeService.gripperCapabilitiesProvider = gripperCapabilitiesProvider;
    }

    @Inject
    public static void setTCPConfigurationFactory(TcpConfigurationFactory tcpConfigurationFactory) {
        ProxyGripperInstallationNodeService.tcpConfigurationFactory = tcpConfigurationFactory;
    }

    public void configureContribution(ContributionConfiguration configuration) {
        ContributionConfiguration contributionConfiguration = configuration;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)contributionConfiguration);
        Object[] objectArray = new Object[]{this, contributionConfiguration, joinPoint};
        ProxyGripperInstallationNodeService$AjcClosure1 proxyGripperInstallationNodeService$AjcClosure1 = new ProxyGripperInstallationNodeService$AjcClosure1(objectArray);
        UncaughtExceptionAspect.aspectOf().aroundMethod(proxyGripperInstallationNodeService$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public String getTitle(Locale locale) {
        Locale locale2 = locale;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)locale2);
        Object[] objectArray = new Object[]{this, locale2, joinPoint};
        ProxyGripperInstallationNodeService$AjcClosure3 proxyGripperInstallationNodeService$AjcClosure3 = new ProxyGripperInstallationNodeService$AjcClosure3(objectArray);
        return (String)UncaughtExceptionAspect.aspectOf().aroundMethod(proxyGripperInstallationNodeService$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    public SwingInstallationNodeView<? extends InstallationNodeContribution> createView(ViewAPIProvider apiProvider) {
        ViewAPIProvider viewAPIProvider = apiProvider;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)viewAPIProvider);
        Object[] objectArray = new Object[]{this, viewAPIProvider, joinPoint};
        ProxyGripperInstallationNodeService$AjcClosure5 proxyGripperInstallationNodeService$AjcClosure5 = new ProxyGripperInstallationNodeService$AjcClosure5(objectArray);
        return (SwingInstallationNodeView)UncaughtExceptionAspect.aspectOf().aroundMethod(proxyGripperInstallationNodeService$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    public InstallationNodeContribution createInstallationNode(InstallationAPIProvider apiProvider, SwingInstallationNodeView view, DataModel model, CreationContext context) {
        InstallationAPIProvider installationAPIProvider = apiProvider;
        SwingInstallationNodeView swingInstallationNodeView = view;
        DataModel dataModel = model;
        CreationContext creationContext = context;
        Object[] objectArray = new Object[]{installationAPIProvider, swingInstallationNodeView, dataModel, creationContext};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, installationAPIProvider, swingInstallationNodeView, dataModel, creationContext, joinPoint};
        ProxyGripperInstallationNodeService$AjcClosure7 proxyGripperInstallationNodeService$AjcClosure7 = new ProxyGripperInstallationNodeService$AjcClosure7(objectArray2);
        return (InstallationNodeContribution)UncaughtExceptionAspect.aspectOf().aroundMethod(proxyGripperInstallationNodeService$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    private void checkForExceptionInGetTitle(Locale locale) {
        this.getTitle(locale);
    }

    private void configureGripper(GripperAPIProviderImpl gripperAPIProvider, GripperContext gripperContext) {
        GripperCapabilitiesImpl gripperCapabilities = (GripperCapabilitiesImpl)gripperCapabilitiesProvider.get();
        gripperCapabilities.init(gripperContext, this.service);
        GripperFeedbackCapabilitiesImpl gripperFeedbackCapabilities = new GripperFeedbackCapabilitiesImpl(gripperContext, this.service.getClass());
        GripperConfigurationImpl configurationAPIProvider = new GripperConfigurationImpl(gripperCapabilities, gripperFeedbackCapabilities);
        try {
            try {
                gripperContext.resetParams();
                gripperContext.setCapabilityRegistrationAllowed(true);
                this.service.configureGripper((GripperConfiguration)configurationAPIProvider, (GripperAPIProvider)gripperAPIProvider);
            }
            catch (RuntimeException e) {
                throw new ProxiedException(e, this.service.getClass(), "com.ur.polyscope.gripper.internal.gripper.installation.ProxyGripperInstallationNodeService", "configureGripper");
            }
        }
        finally {
            gripperContext.setCapabilityRegistrationAllowed(false);
        }
    }

    private void configureInstallation(DataModel model, InstallationAPIProvider apiProvider, GripperAPIProviderImpl gripperAPIProvider) {
        InstallationDefined defined = new InstallationDefined();
        try {
            this.customConfiguration = this.builder.createCustomConfiguration(model);
            CustomUserInputConfiguration throwAfterConfiguration = ProxyCustomUserInputConfiguration.createProxy(this.customConfiguration);
            this.installationValid.setDefineable(defined);
            if (this.customConfiguration instanceof Defined) {
                defined.setCustomConfiguration((Defined)this.customConfiguration);
            }
            TCPConfiguration tcpConfiguration = tcpConfigurationFactory.createTCPConfiguration(this.service.getClass(), "");
            this.doConfigureInstallation(apiProvider, gripperAPIProvider, throwAfterConfiguration, tcpConfiguration);
        }
        catch (RuntimeException e) {
            defined.setError(true);
            throw e;
        }
    }

    private void doConfigureInstallation(InstallationAPIProvider apiProvider, GripperAPIProviderImpl gripperAPIProvider, CustomUserInputConfiguration throwAfterConfiguration, TCPConfiguration tcpConfiguration) {
        try {
            try {
                this.service.configureInstallation(throwAfterConfiguration, (SystemConfiguration)new SystemConfigurationImpl(apiProvider, this.service.getClass(), tcpConfigurationFactory), tcpConfiguration, (GripperAPIProvider)gripperAPIProvider);
            }
            catch (RuntimeException e) {
                throw new ProxiedException(e, this.service.getClass(), "com.ur.polyscope.gripper.internal.gripper.installation.ProxyGripperInstallationNodeService", "configureInstallation");
            }
        }
        finally {
            ProxyCustomUserInputConfiguration.throwOnUseOfProxy(throwAfterConfiguration);
        }
    }

    private InstallationNodeContribution createInstallationNodeContribution(SwingInstallationNodeView view) {
        InstallationNodeContribution node = this.builder.createNodeContribution((PreambleGeneratorService)new MyPreambleGeneratorService(), view);
        if (this.customConfiguration instanceof Updatable) {
            ((Updatable)this.customConfiguration).update();
        }
        if (this.exceptionThrownDuringCreate != null) {
            throw this.exceptionThrownDuringCreate;
        }
        return node;
    }

    public String toString() {
        return this.service.getClass().getName();
    }

    public void finalizeDataModelReset() {
        if (this.customConfiguration instanceof DataModelResetable) {
            ((DataModelResetable)this.customConfiguration).finalizeDataModelReset();
        }
    }

    public boolean isFinalizeRequired() {
        if (this.customConfiguration instanceof DataModelResetable) {
            return ((DataModelResetable)this.customConfiguration).isFinalizeRequired();
        }
        return false;
    }

    static {
        ProxyGripperInstallationNodeService.ajc$preClinit();
    }

    static final /* synthetic */ void configureContribution_aroundBody0(ProxyGripperInstallationNodeService ajc$this, ContributionConfiguration configuration, JoinPoint joinPoint) {
        if (ajc$this.exceptionThrownDuringCreate != null) {
            throw ajc$this.exceptionThrownDuringCreate;
        }
    }

    static final /* synthetic */ String getTitle_aroundBody2(ProxyGripperInstallationNodeService ajc$this, Locale locale, JoinPoint joinPoint) {
        if (ajc$this.title == null) {
            try {
                ajc$this.title = ajc$this.service.getTitle(locale);
            }
            catch (RuntimeException e) {
                throw new ProxiedException(e, ajc$this.service.getClass(), "com.ur.polyscope.gripper.internal.gripper.installation.ProxyGripperInstallationNodeService", "getTitle");
            }
        }
        return ajc$this.title;
    }

    static final /* synthetic */ SwingInstallationNodeView createView_aroundBody4(ProxyGripperInstallationNodeService ajc$this, ViewAPIProvider apiProvider, JoinPoint joinPoint) {
        ImageIcon logo = ajc$this.contributionConfiguration.getLogo();
        if (logo != null) {
            return ajc$this.builder.createView(apiProvider, logo);
        }
        return ajc$this.builder.createView(apiProvider, (ImageIcon)ImageResource.defaultLogo());
    }

    static final /* synthetic */ InstallationNodeContribution createInstallationNode_aroundBody6(ProxyGripperInstallationNodeService ajc$this, InstallationAPIProvider apiProvider, SwingInstallationNodeView view, DataModel model, CreationContext context, JoinPoint joinPoint) {
        try {
            ajc$this.checkForExceptionInGetTitle(apiProvider.getSystemAPI().getSystemSettings().getLocalization().getLocale());
            GripperAPIProviderImpl gripperAPIProvider = new GripperAPIProviderImpl(apiProvider);
            ajc$this.configureGripper(gripperAPIProvider, ajc$this.gripperContext);
            ajc$this.configureInstallation(model, apiProvider, gripperAPIProvider);
            return ajc$this.createInstallationNodeContribution(view);
        }
        catch (RuntimeException e) {
            ajc$this.gripperContext.setInitializationException(e);
            throw e;
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ProxyGripperInstallationNodeService.java", ProxyGripperInstallationNodeService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "configureContribution", "com.ur.polyscope.gripper.internal.gripper.installation.ProxyGripperInstallationNodeService", "com.ur.urcap.api.contribution.installation.ContributionConfiguration", "configuration", "", "void"), 77);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTitle", "com.ur.polyscope.gripper.internal.gripper.installation.ProxyGripperInstallationNodeService", "java.util.Locale", "locale", "", "java.lang.String"), 84);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createView", "com.ur.polyscope.gripper.internal.gripper.installation.ProxyGripperInstallationNodeService", "com.ur.urcap.api.contribution.ViewAPIProvider", "apiProvider", "", "com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeView"), 99);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createInstallationNode", "com.ur.polyscope.gripper.internal.gripper.installation.ProxyGripperInstallationNodeService", "com.ur.urcap.api.contribution.installation.InstallationAPIProvider:com.ur.urcap.api.contribution.installation.swing.SwingInstallationNodeView:com.ur.urcap.api.domain.data.DataModel:com.ur.urcap.api.contribution.installation.CreationContext", "apiProvider:view:model:context", "", "com.ur.urcap.api.contribution.InstallationNodeContribution"), 108);
    }

    private class MyPreambleGeneratorService
    implements PreambleGeneratorService {
        private MyPreambleGeneratorService() {
        }

        public void generatePreamble(ScriptWriter scriptWriter) {
            try {
                ProxyGripperInstallationNodeService.this.service.generatePreambleScript(scriptWriter);
            }
            catch (RuntimeException e) {
                throw new ProxiedException(e, ProxyGripperInstallationNodeService.this.service.getClass(), "com.ur.polyscope.gripper.internal.gripper.installation.ProxyGripperInstallationNodeService$MyPreambleGeneratorService", "generatePreamble");
            }
            FeedbackPreambleGenerator feedbackPreambleGenerator = new FeedbackPreambleGenerator(ProxyGripperInstallationNodeService.this.gripperContext);
            feedbackPreambleGenerator.generatePreamble(scriptWriter);
        }
    }
}

