/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.operations;

import com.ur.polyscope.gripper.internal.gripper.operations.UISetOperationAction;
import com.ur.polyscope.gripper.internal.gripper.params.Operation;
import com.ur.polyscope.gripper.internal.gripper.program.actions.GripperProgramNode;
import com.ur.polyscope.gripper.internal.gripper.program.ui.ActiveOperation;
import com.ur.polyscope.gripper.resource.internal.TextResource;
import com.ur.swing.EnumButtonGroup;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.util.swing.HTML;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JRadioButton;

public class SelectOperationsPanel
implements ActiveOperation {
    private final Provider<UISetOperationAction> setOperationProvider;
    private final ViewContext viewContext;
    private EnumButtonGroup<Operation> actionSelection;

    @Inject
    public SelectOperationsPanel(Provider<UISetOperationAction> setOperationProvider, ViewContext viewContext) {
        this.setOperationProvider = setOperationProvider;
        this.viewContext = viewContext;
    }

    public void buildUI(Provider<GripperProgramNode> provider, FormBuilder formBuilder) {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        WidgetFactory wf = this.viewContext.createWidgetFactory();
        this.actionSelection = new EnumButtonGroup(Operation.class);
        UISetOperationAction selectGripOperationAction = (UISetOperationAction)((Object)this.setOperationProvider.get());
        selectGripOperationAction.initialize(Operation.GRIP, provider);
        JRadioButton grip = wf.createRadioButton((Action)((Object)selectGripOperationAction));
        UISetOperationAction selectReleaseOperationAction = (UISetOperationAction)((Object)this.setOperationProvider.get());
        selectReleaseOperationAction.initialize(Operation.RELEASE, provider);
        JRadioButton release = wf.createRadioButton((Action)((Object)selectReleaseOperationAction));
        this.actionSelection.add((Enum)Operation.GRIP, (AbstractButton)grip);
        this.actionSelection.add((Enum)Operation.RELEASE, (AbstractButton)release);
        formBuilder.label(HTML.fontBold((String)textResource.selectAction()), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS}).end().component((JComponent)grip, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().component((JComponent)release, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end();
    }

    public void initialize(Operation operation) {
        if (operation == Operation.UNDEFINED) {
            this.actionSelection.clearSelection();
        } else {
            this.actionSelection.select((Enum)operation);
        }
    }

    @Override
    public boolean isSelected(Operation operation) {
        return this.actionSelection.get((Enum)operation).isSelected();
    }
}

