/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.operations;

import com.ur.polyscope.gripper.internal.gripper.params.Operation;
import com.ur.polyscope.gripper.internal.gripper.program.actions.AbstractProgramTreeAction;
import com.ur.polyscope.gripper.internal.gripper.program.actions.GripperProgramNode;
import com.ur.polyscope.gripper.internal.gripper.program.actions.ToggleFeedbackDetectionAction;

public class SetOperationAction
extends AbstractProgramTreeAction {
    private final GripperProgramNode contribution;
    private final Operation operation;

    public SetOperationAction(GripperProgramNode contribution, Operation operation) {
        super(contribution.getRootTreeNode(), contribution.getTreeModificationVeto());
        this.contribution = contribution;
        this.operation = operation;
    }

    @Override
    public void execute() {
        Operation fromOperation = this.contribution.getOperation();
        this.contribution.setOperation(this.operation);
        if (this.contribution.isFeedbackDetectionSupported(this.operation)) {
            if (this.contribution.isFeedbackDetectionEnabled()) {
                if (!this.contribution.isFeedbackDetectionSupported(fromOperation)) {
                    this.cleanSubtree();
                    ToggleFeedbackDetectionAction enableDetection = new ToggleFeedbackDetectionAction(this.contribution, true);
                    enableDetection.execute();
                }
            } else {
                this.cleanSubtree();
            }
        } else {
            this.cleanSubtree();
        }
    }
}

