/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.operations;

import com.ur.polyscope.gripper.internal.gripper.operations.DialogConfirmationAction;
import com.ur.polyscope.gripper.internal.gripper.operations.SetOperationAction;
import com.ur.polyscope.gripper.internal.gripper.params.Operation;
import com.ur.polyscope.gripper.internal.gripper.program.actions.GripperProgramNode;
import com.ur.polyscope.gripper.internal.gripper.program.ui.UIAction;
import com.ur.polyscope.gripper.internal.gripper.program.ui.UIInitializeViewAction;
import com.ur.polyscope.gripper.resource.internal.TextResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.dialog.ConfirmationDialogCreator;
import com.ur.swing.dialog.ConfirmationMessage;
import java.awt.event.ActionEvent;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.JRadioButton;

public final class UISetOperationAction
extends AbstractActionDefinition {
    private static final String ACTION_NAME = "RadioButton.ProgramNodeView";
    private final TextResource textResource;
    private final ConfirmationDialogCreator confirmationDialogCreator;
    private Operation operation;
    private String operationName;
    private Provider<GripperProgramNode> contributionProvider;

    @Inject
    public UISetOperationAction(TextResource textResource, ConfirmationDialogCreator confirmationDialogCreator) {
        this.textResource = textResource;
        this.confirmationDialogCreator = confirmationDialogCreator;
    }

    void initialize(Operation operation, Provider<GripperProgramNode> contributionProvider) {
        this.operation = operation;
        this.contributionProvider = contributionProvider;
        this.operationName = UISetOperationAction.getOperationName(operation, this.textResource);
        this.putValue("Name", this.operationName);
        this.putValue("InternalName", String.valueOf(this.operationName) + ACTION_NAME);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        GripperProgramNode contribution = (GripperProgramNode)this.contributionProvider.get();
        Operation revertOperation = contribution.getOperation();
        if (this.operation == revertOperation) {
            return;
        }
        Object source = actionEvent.getSource();
        if (!(source instanceof JRadioButton)) {
            return;
        }
        UIAction action = new UIAction(contribution);
        action.append(new SetOperationAction(contribution, this.operation));
        if (this.isRequireConfirmation(contribution, revertOperation, this.operation)) {
            this.executeWithConfirmation(contribution, revertOperation, action);
        } else {
            action.execute();
        }
    }

    private boolean isRequireConfirmation(GripperProgramNode contribution, Operation fromOperation, Operation toOperation) {
        boolean requireConfirmation = false;
        if (contribution.isFeedbackDetectionSupported(fromOperation) && contribution.isFeedbackDetectionEnabled() && fromOperation != Operation.UNDEFINED && !contribution.isFeedbackDetectionSupported(toOperation)) {
            requireConfirmation = true;
        }
        return requireConfirmation;
    }

    private void executeWithConfirmation(GripperProgramNode contribution, Operation revertOperation, UIAction action) {
        String revertOperationName = UISetOperationAction.getOperationName(revertOperation, this.textResource);
        ConfirmationMessage confirmationMessage = new ConfirmationMessage(this.textResource.removeTitle(revertOperationName), this.textResource.removeMessage(revertOperationName, this.operationName), this.textResource.changeAction(), this.textResource.cancel());
        DialogConfirmationAction confirmation = new DialogConfirmationAction(this.confirmationDialogCreator, confirmationMessage, new UIInitializeViewAction(contribution));
        confirmation.append(action);
        confirmation.execute();
    }

    private static String getOperationName(Operation operation, TextResource textResource) {
        String name;
        switch (operation) {
            case UNDEFINED: {
                name = textResource.undefined();
                break;
            }
            case GRIP: {
                name = textResource.grip();
                break;
            }
            case RELEASE: {
                name = textResource.release();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation type:" + operation);
            }
        }
        return name;
    }
}

