/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.params;

import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.RobotMessageListener;
import com.ur.polyscope.gripper.internal.gripper.params.ActionParameters;
import com.ur.polyscope.gripper.internal.gripper.params.Controller;
import com.ur.polyscope.gripper.internal.gripper.params.Operation;
import com.ur.polyscope.initializerobot.RobotInitializationService;
import com.ur.polyscope.scriptwriter.urcap.URCapScriptWriter;
import com.ur.polyscope.urcaps.exception.ProxiedException;
import com.ur.urcap.api.contribution.driver.gripper.GripActionParameters;
import com.ur.urcap.api.contribution.driver.gripper.GripperContribution;
import com.ur.urcap.api.contribution.driver.gripper.ReleaseActionParameters;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.SelectableGripper;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.util.Waiting;
import java.util.concurrent.TimeUnit;

public abstract class Actions
implements RobotMessageListener {
    protected final GripperContribution contribution;
    protected static RobotInitializationService robotInitializationService;
    private boolean programActive;

    public Actions(GripperContribution contribution) {
        this.contribution = contribution;
    }

    public static void setRobotInitializationService(RobotInitializationService robotInitializationService) {
        Actions.robotInitializationService = robotInitializationService;
    }

    public boolean checkRobotState() {
        boolean isRobotStateValid;
        if (robotInitializationService != null && !(isRobotStateValid = robotInitializationService.isRobotRunning())) {
            this.showInitializeRobotToolTip();
            return false;
        }
        return true;
    }

    private void showInitializeRobotToolTip() {
        robotInitializationService.initializeRobot();
    }

    public abstract void onGripperSelected(SelectableGripper var1);

    public abstract void onGripButton();

    public abstract void onReleaseButton();

    protected ScriptWriter generateScriptCode(ActionParameters parameters, Operation operation) {
        URCapScriptWriter scriptWriter = new URCapScriptWriter(new com.ur.polyscope.scriptwriter.ScriptWriter());
        this.getPreambleScript((ScriptWriter)scriptWriter);
        switch (operation) {
            case GRIP: {
                this.getGripActionScript(parameters, (ScriptWriter)scriptWriter);
                break;
            }
            case RELEASE: {
                this.getReleaseActionScript(parameters, (ScriptWriter)scriptWriter);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
        return scriptWriter;
    }

    private void getPreambleScript(ScriptWriter scriptWriter) {
        try {
            this.contribution.generatePreambleScript(scriptWriter);
        }
        catch (RuntimeException e) {
            throw new ProxiedException(e, this.contribution.getClass(), "com.ur.polyscope.gripper.internal.gripper.params.Actions", "getPreambleScript");
        }
    }

    private void getGripActionScript(ActionParameters parameters, ScriptWriter scriptWriter) {
        try {
            this.contribution.generateGripActionScript(scriptWriter, (GripActionParameters)parameters);
        }
        catch (RuntimeException e) {
            throw new ProxiedException(e, this.contribution.getClass(), "com.ur.polyscope.gripper.internal.gripper.params.Actions", "getGripActionScript");
        }
    }

    private void getReleaseActionScript(ActionParameters parameters, ScriptWriter scriptWriter) {
        try {
            this.contribution.generateReleaseActionScript(scriptWriter, (ReleaseActionParameters)parameters);
        }
        catch (RuntimeException e) {
            throw new ProxiedException(e, this.contribution.getClass(), "com.ur.polyscope.gripper.internal.gripper.params.Actions", "getReleaseActionScript");
        }
    }

    protected void sendScriptToController(String script) {
        Controller.sendInkognito(script);
    }

    public void handleRobotMessage(RobotMessage robotMessage) {
        this.programActive = robotMessage.getProgramState().isActive();
    }

    protected void sendStopProgramToController() {
        Controller.sendStopProgram();
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return !Actions.this.programActive;
            }
        }, (int)1, (TimeUnit)TimeUnit.SECONDS);
    }
}

