/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.params;

import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import java.util.StringTokenizer;
import javax.inject.Inject;

public final class Controller {
    private static final Logger LOG = LogFactory.createLogger(Controller.class);
    private static ControllerInterface controllerInterface;
    private static final String INKOGNITO = "inkognito";

    private Controller() {
    }

    @Inject
    public static void setControllerInterface(ControllerInterface controllerInterface) {
        Controller.controllerInterface = controllerInterface;
    }

    public static void sendInkognito(String script) {
        StringBuilder b = new StringBuilder();
        b.append("def inkognito():\n");
        Controller.createBody(script, b);
        b.append("end\n");
        Controller.sendScript(script, b.toString());
    }

    public static void sendSec(String script) {
        StringBuilder b = new StringBuilder();
        b.append("sec p():\n");
        Controller.createBody(script, b);
        b.append("end\n");
        Controller.sendScript(script, b.toString());
    }

    private static void createBody(String script, StringBuilder b) {
        StringTokenizer stringTokenizer = new StringTokenizer(script, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            b.append("  ");
            b.append(stringTokenizer.nextToken());
            b.append("\n");
        }
    }

    private static void sendScript(String script, String encapsulatedScript) {
        if (controllerInterface.isConnected()) {
            controllerInterface.runScript(encapsulatedScript);
        } else {
            LOG.info("Controller is unavailable to receive script, %s", new Object[]{script});
        }
    }

    public static void sendStopProgram() {
        boolean didWritBytes;
        if (controllerInterface.isConnected() && (didWritBytes = controllerInterface.runScript("stop program\n"))) {
            controllerInterface.setUserProgramOnRobot(false);
        }
    }
}

