/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.params;

import com.ur.polyscope.gripper.internal.gripper.params.Operation;
import com.ur.polyscope.gripper.internal.gripper.params.Param;
import com.ur.polyscope.program.ProgramTreeRenderingTriggerer;
import com.ur.polyscope.valueobjects.NumberValue;
import com.ur.urcap.api.contribution.driver.gripper.capability.InvalidCapabilityRange;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Provider;

public abstract class GripOnlyParam<T extends NumberValue<?>>
implements Param<T> {
    protected final List<GripOnlyParam> dependantList = new ArrayList<GripOnlyParam>();
    public static final String OPERATION = "OPERATION";
    protected Provider<ProgramTreeRenderingTriggerer> programTreeRenderingProvider;
    private final String dataModelKey;
    private final String description;
    private T minValue;
    private T maxValue;
    protected T defaultGrip;

    public GripOnlyParam(String dataModelKey, String description, T min, T max, T defaultGrip) {
        this.checkForInvalidRange(min, max, defaultGrip);
        this.dataModelKey = dataModelKey;
        this.description = description;
        this.minValue = min;
        this.maxValue = max;
        this.defaultGrip = defaultGrip;
    }

    protected void updateParam(T min, T max, T defaultGrip) {
        this.checkForInvalidRange(min, max, defaultGrip);
        this.minValue = min;
        this.maxValue = max;
        this.defaultGrip = defaultGrip;
        this.updateParamForDependants(min, max, defaultGrip);
    }

    private void updateParamForDependants(T min, T max, T defaultGrip) {
        for (GripOnlyParam dependant : this.dependantList) {
            dependant.updateParam(min, max, defaultGrip);
        }
    }

    private void checkForInvalidRange(T min, T max, T defaultGrip) {
        if (min.asDouble() >= max.asDouble()) {
            throw new InvalidCapabilityRange("Min value is larger than max value");
        }
        if (min.asDouble() > defaultGrip.asDouble()) {
            throw new InvalidCapabilityRange("Default grip value is less than min value");
        }
        if (max.asDouble() < defaultGrip.asDouble()) {
            throw new InvalidCapabilityRange("Default grip value is larger than max value");
        }
    }

    public String getDataModelKey() {
        return this.dataModelKey;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public T getDefaultValue(Operation operation) {
        return this.defaultGrip;
    }

    @Override
    public T getMinValue() {
        return this.minValue;
    }

    @Override
    public T getMaxValue() {
        return this.maxValue;
    }

    public void setProgramTreeRenderingProvider(Provider<ProgramTreeRenderingTriggerer> programTreeRenderingProvider) {
        this.programTreeRenderingProvider = programTreeRenderingProvider;
    }

    protected void onUpdate() {
        ProgramTreeRenderingTriggerer trigger = (ProgramTreeRenderingTriggerer)this.programTreeRenderingProvider.get();
        if (trigger != null) {
            trigger.reRenderTree(250L, true);
        }
    }

    public abstract GripOnlyParam copy();

    public void addDependant(GripOnlyParam copy) {
        this.dependantList.add(copy);
    }
}

