/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.params;

import com.ur.polyscope.gripper.internal.gripper.params.GripOnlyParam;
import com.ur.polyscope.gripper.internal.gripper.params.Operation;
import com.ur.polyscope.valueobjects.NumberValue;
import com.ur.urcap.api.contribution.driver.gripper.capability.InvalidCapabilityRange;

public abstract class GripReleaseParam<T extends NumberValue<?>>
extends GripOnlyParam<T> {
    private T defaultRelease;

    public GripReleaseParam(String dataModelKey, String description, T min, T max, T defaultGrip, T defaultRelease) {
        super(dataModelKey, description, min, max, defaultGrip);
        this.checkForInvalidReleaseRange(min, max, defaultRelease);
        this.defaultRelease = defaultRelease;
    }

    protected void updateParam(T min, T max, T defaultGrip, T defaultRelease) {
        this.checkForInvalidReleaseRange(min, max, defaultRelease);
        this.defaultRelease = defaultRelease;
        super.updateParam(min, max, defaultGrip);
        this.updateParamForDependants(defaultRelease);
    }

    private void updateParamForDependants(T defaultRelease) {
        for (GripOnlyParam dependant : this.dependantList) {
            if (!(dependant instanceof GripReleaseParam)) continue;
            ((GripReleaseParam)dependant).defaultRelease = defaultRelease;
        }
    }

    private void checkForInvalidReleaseRange(T min, T max, T defaultRelease) {
        if (min.asDouble() > defaultRelease.asDouble()) {
            throw new InvalidCapabilityRange("Default release value is less than min value");
        }
        if (max.asDouble() < defaultRelease.asDouble()) {
            throw new InvalidCapabilityRange("Default release value is larger than max value");
        }
    }

    @Override
    public T getDefaultValue(Operation operation) {
        switch (operation) {
            case UNDEFINED: 
            case GRIP: {
                return (T)this.defaultGrip;
            }
            case RELEASE: {
                return this.defaultRelease;
            }
        }
        throw new IllegalArgumentException("Unsupported operation " + operation);
    }
}

