/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.params;

import com.ur.polyscope.gripper.internal.gripper.feedback.FeedbackDefinition;
import com.ur.polyscope.gripper.internal.gripper.feedback.FeedbackDefinitions;
import com.ur.polyscope.gripper.internal.gripper.params.GripperFunctions;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.GripperNodeConfig;

public enum Operation implements GripperFunctions
{
    UNDEFINED{

        @Override
        public boolean isFeedbackDetectionSupported(FeedbackDefinitions gripperContext) {
            return false;
        }

        @Override
        public String getFeedbackFunction(FeedbackDefinitions gripperContext, String individualMultiGripperUniqueId) {
            return "Unknown operation type: " + this;
        }
    }
    ,
    GRIP{

        @Override
        public String getFeedbackFunction(FeedbackDefinitions gripperContext, String individualMultiGripperUniqueId) {
            return 2.getFeedbackFunction(gripperContext, "is_grip_detected", individualMultiGripperUniqueId);
        }

        @Override
        public boolean isFeedbackDetectionSupported(FeedbackDefinitions context) {
            return context.hasFeedbackDefinitions("is_grip_detected");
        }
    }
    ,
    RELEASE{

        @Override
        public String getFeedbackFunction(FeedbackDefinitions gripperContext, String individualMultiGripperUniqueId) {
            return 3.getFeedbackFunction(gripperContext, "is_release_detected", individualMultiGripperUniqueId);
        }

        @Override
        public boolean isFeedbackDetectionSupported(FeedbackDefinitions context) {
            return context.hasFeedbackDefinitions("is_release_detected");
        }
    };


    private Operation() {
    }

    public boolean isDefined() {
        return this != UNDEFINED;
    }

    static String getFeedbackFunction(FeedbackDefinitions gripperContext, String feedbackType, String individualMultiGripperUniqueId) {
        for (FeedbackDefinition feedbackDefinition : gripperContext.getFeedbackDefinitions()) {
            if (!feedbackDefinition.getFunctionName().equals(feedbackType)) continue;
            return String.valueOf(feedbackDefinition.getFunctionName(String.valueOf(gripperContext.getContributionId()), individualMultiGripperUniqueId)) + "()";
        }
        return "Feedback function not found: " + feedbackType;
    }

    public static Operation convertFrom(GripperNodeConfig.ConfigType configType) {
        switch (configType) {
            case GRIP_ACTION: {
                return GRIP;
            }
            case RELEASE_ACTION: {
                return RELEASE;
            }
        }
        return UNDEFINED;
    }

    /* synthetic */ Operation(String string, int n, Operation operation) {
        this();
    }
}

