/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.params;

import com.ur.polyscope.gripper.internal.gripper.params.GripForceParam;
import com.ur.polyscope.gripper.internal.gripper.params.GripOnlyParam;
import com.ur.polyscope.gripper.internal.gripper.params.GripVacuumParam;
import com.ur.polyscope.gripper.internal.gripper.params.SpeedParam;
import com.ur.polyscope.gripper.internal.gripper.params.WidthParam;
import java.util.LinkedHashMap;

public class ParamsDefinition {
    public static final String WIDTH = "WIDTH";
    public static final String FORCE = "FORCE";
    public static final String SPEED = "SPEED";
    public static final String VACUUM = "VACUUM";
    protected final LinkedHashMap<String, GripOnlyParam<?>> params = new LinkedHashMap();

    public ParamsDefinition() {
    }

    public ParamsDefinition(ParamsDefinition master) {
        for (GripOnlyParam<?> org : master.params.values()) {
            GripOnlyParam copy = org.copy();
            org.addDependant(copy);
            this.append(copy);
        }
    }

    public void append(GripOnlyParam param) {
        this.params.put(param.getDataModelKey(), param);
    }

    public boolean contains(String paramName) {
        return this.params.containsKey(paramName);
    }

    public boolean isEmpty() {
        return this.params.isEmpty();
    }

    public void resetParams() {
        this.params.clear();
    }

    public boolean isWidthDefined() {
        return this.contains(WIDTH);
    }

    public boolean isForceDefined() {
        return this.contains(FORCE);
    }

    public boolean isSpeedDefined() {
        return this.contains(SPEED);
    }

    public boolean isVacuumDefined() {
        return this.contains(VACUUM);
    }

    public WidthParam getWidthParamDefinition() {
        return (WidthParam)this.params.get(WIDTH);
    }

    public GripForceParam getForceParamDefinition() {
        return (GripForceParam)this.params.get(FORCE);
    }

    public GripVacuumParam getVacuumParamDefinition() {
        return (GripVacuumParam)this.params.get(VACUUM);
    }

    public SpeedParam getSpeedParamDefinition() {
        return (SpeedParam)this.params.get(SPEED);
    }

    public int parametersDefined() {
        return this.params.size();
    }
}

