/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.params;

import com.ur.polyscope.gripper.internal.gripper.params.GripForceParam;
import com.ur.polyscope.gripper.internal.gripper.params.GripVacuumParam;
import com.ur.polyscope.gripper.internal.gripper.params.Operation;
import com.ur.polyscope.gripper.internal.gripper.params.ParamsDataModel;
import com.ur.polyscope.gripper.internal.gripper.params.ParamsDefinition;
import com.ur.polyscope.gripper.internal.gripper.params.ScriptGenerationParams;
import com.ur.polyscope.gripper.internal.gripper.params.SpeedParam;
import com.ur.polyscope.gripper.internal.gripper.params.WidthParam;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.SelectableGripper;
import com.ur.urcap.api.domain.value.simple.Force;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.Pressure;
import com.ur.urcap.api.domain.value.simple.Speed;

public class ScriptGenerationParamsBuilder {
    private SelectableGripper gripper;
    private Force force;
    private Length width;
    private Pressure vacuum;
    private Speed speed;
    private boolean gripDetectionSupported;
    private boolean gripDetectionEnabled;
    private boolean releaseDetectionSupported;
    private boolean releaseDetectionEnabled;

    public ScriptGenerationParamsBuilder with(ParamsDataModel model, Operation operation) {
        this.force = operation == Operation.GRIP ? model.getForce() : null;
        this.width = model.getWidth();
        this.vacuum = operation == Operation.GRIP ? model.getVacuum() : null;
        this.speed = model.getSpeed();
        return this;
    }

    public ScriptGenerationParamsBuilder with(ParamsDefinition paramDefinition, Operation operation) {
        GripForceParam forceParam = paramDefinition.getForceParamDefinition();
        this.force = forceParam != null && operation == Operation.GRIP ? (Force)forceParam.getDefaultValue(operation) : null;
        WidthParam widthParam = paramDefinition.getWidthParamDefinition();
        this.width = widthParam != null ? (Length)widthParam.getDefaultValue(operation) : null;
        GripVacuumParam vacuumParam = paramDefinition.getVacuumParamDefinition();
        this.vacuum = vacuumParam != null && operation == Operation.GRIP ? (Pressure)vacuumParam.getDefaultValue(operation) : null;
        SpeedParam speedParam = paramDefinition.getSpeedParamDefinition();
        this.speed = speedParam != null ? (Speed)speedParam.getDefaultValue(operation) : null;
        return this;
    }

    public ScriptGenerationParamsBuilder with(Force force) {
        this.force = force;
        return this;
    }

    public ScriptGenerationParamsBuilder with(Length width) {
        this.width = width;
        return this;
    }

    public ScriptGenerationParamsBuilder with(Pressure vacuum) {
        this.vacuum = vacuum;
        return this;
    }

    public ScriptGenerationParamsBuilder with(Speed speed) {
        this.speed = speed;
        return this;
    }

    public ScriptGenerationParamsBuilder with(SelectableGripper gripper) {
        this.gripper = gripper;
        return this;
    }

    public ScriptGenerationParamsBuilder withGripDetectionSupported(boolean gripDetectionSupported) {
        this.gripDetectionSupported = gripDetectionSupported;
        return this;
    }

    public ScriptGenerationParamsBuilder withGripDetectionEnabled(boolean gripDetectionEnabled) {
        this.gripDetectionEnabled = gripDetectionEnabled;
        return this;
    }

    public ScriptGenerationParamsBuilder withReleaseDetectionSupported(boolean releaseDetectionSupported) {
        this.releaseDetectionSupported = releaseDetectionSupported;
        return this;
    }

    public ScriptGenerationParamsBuilder withReleaseDetectionEnabled(boolean releaseDetectionEnabled) {
        this.releaseDetectionEnabled = releaseDetectionEnabled;
        return this;
    }

    public ScriptGenerationParams build() {
        ScriptGenerationParams params = new ScriptGenerationParams();
        params.gripper = this.gripper;
        params.force = this.force;
        params.width = this.width;
        params.vacuum = this.vacuum;
        params.speed = this.speed;
        params.gripDetectionSupported = this.gripDetectionSupported;
        params.gripDetectionEnabled = this.gripDetectionEnabled;
        params.releaseDetectionSupported = this.releaseDetectionSupported;
        params.releaseDetectionEnabled = this.releaseDetectionEnabled;
        return params;
    }
}

