/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.params.view;

import com.ur.polyscope.gripper.internal.gripper.GripperContext;
import com.ur.polyscope.gripper.internal.gripper.params.GripForceParam;
import com.ur.polyscope.gripper.internal.gripper.params.GripVacuumParam;
import com.ur.polyscope.gripper.internal.gripper.params.Operation;
import com.ur.polyscope.gripper.internal.gripper.params.ParamsDataModel;
import com.ur.polyscope.gripper.internal.gripper.params.ParamsDefinition;
import com.ur.polyscope.gripper.internal.gripper.params.SetParamProviders;
import com.ur.polyscope.gripper.internal.gripper.params.SpeedParam;
import com.ur.polyscope.gripper.internal.gripper.params.WidthParam;
import com.ur.polyscope.gripper.internal.gripper.params.view.Slider;
import com.ur.polyscope.gripper.internal.gripper.params.view.SliderFactory;
import com.ur.polyscope.gripper.internal.gripper.params.view.UIActionFactory;
import com.ur.polyscope.gripper.internal.gripper.params.view.URCapAPIValueConverters;
import com.ur.polyscope.gripper.internal.gripper.program.actions.GripperProgramNode;
import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadContribution;
import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadNotSelected;
import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadPanel;
import com.ur.polyscope.gripper.internal.gripper.program.payload.action.SetTotalPayload;
import com.ur.polyscope.gripper.internal.gripper.program.ui.Style;
import com.ur.polyscope.gripper.resource.internal.TextResource;
import com.ur.polyscope.valueobjects.Force;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.Pressure;
import com.ur.polyscope.valueobjects.Speed;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.urcap.api.domain.payload.Payload;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidationFactory;
import com.ur.util.swing.HTML;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.JComponent;

public class ParametersDefinedPanel {
    public static final int PARAMS_WITH_MULTIGRIP = 5;
    public static final int PARAMS_WITHOUT_MULTIGRIP = 7;
    public static final int PAYLOAD_PARAMETER = 2;
    private final InputValidationFactory inputValidationFactory;
    private final PayloadPanel payloadPanel;
    private final Style style;
    private final ViewContext viewContext;
    private Provider<GripperProgramNode> provider;
    private GripperContext gripperContext;
    protected Slider<Length> widthField;
    protected Slider<Force> forceField;
    protected Slider<Pressure> vacuumField;
    protected Slider<Speed> speedField;

    @Inject
    public ParametersDefinedPanel(InputValidationFactory inputValidationFactory, PayloadPanel payloadPanel, Style style, ViewContext viewContext) {
        this.inputValidationFactory = inputValidationFactory;
        this.payloadPanel = payloadPanel;
        this.style = style;
        this.viewContext = viewContext;
    }

    public void buildUI(final Provider<GripperProgramNode> provider, SetParamProviders actions, GripperContext gripperContext, FormBuilder formBuilder) {
        this.provider = provider;
        this.gripperContext = gripperContext;
        this.payloadPanel.setModifyListener(new SetTotalPayload(new Provider<PayloadContribution>(){

            public PayloadContribution get() {
                return (PayloadContribution)provider.get();
            }
        }, new UIActionFactory(provider)));
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        SliderFactory factory = new SliderFactory(formBuilder, this.inputValidationFactory);
        ParamsDefinition definitions = gripperContext.getParamsDefinition();
        this.style.addSeparator(this.viewContext.createWidgetFactory(), formBuilder, FormBuilder.PanelConstraints.SPAN_COLUMNS);
        formBuilder.label(HTML.html((String)HTML.fontBold((String)textResource.parameters())), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS}).end();
        this.widthField = factory.createSlider(actions.getWidthParamSetter(), definitions.getWidthParamDefinition(), URCapAPIValueConverters.LENGTH_CONVERTER, UnitsValueConverterFactory.getLengthConverter());
        this.speedField = factory.createSlider(actions.getSpeedParamSetter(), definitions.getSpeedParamDefinition(), URCapAPIValueConverters.SPEED_CONVERTER, UnitsValueConverterFactory.getSpeedConverter());
        this.forceField = factory.createSlider(actions.getForceParamSetter(), definitions.getForceParamDefinition(), URCapAPIValueConverters.FORCE_CONVERTER, UnitsValueConverterFactory.getForceConverter());
        this.vacuumField = factory.createSlider(actions.getVacuumParamSetter(), definitions.getVacuumParamDefinition(), URCapAPIValueConverters.PRESSURE_CONVERTER, UnitsValueConverterFactory.getPressureConverter());
        this.payloadPanel.update(false, false, new PayloadNotSelected());
        this.payloadPanel.layout(formBuilder);
        int i = 0;
        while (i < this.getMaxRows(this.style) - this.numberOfParameters(definitions)) {
            formBuilder.spacer().end();
            ++i;
        }
    }

    private int numberOfParameters(ParamsDefinition definitions) {
        return definitions.parametersDefined() + 2;
    }

    private int getMaxRows(Style style) {
        return (this.gripperContext.isMultiGripper() ? 5 : 7) + style.getExtraParameterRows();
    }

    public void initialize(Operation operation, ParamsDataModel dataModel, ParamsDefinition paramsDefinition) {
        GripperProgramNode node = (GripperProgramNode)this.provider.get();
        boolean usePayload = node.isUsePayload();
        Payload payload = node.getPayload();
        this.payloadPanel.update(operation != Operation.UNDEFINED, usePayload, payload);
        this.setEnablement(operation, this.widthField, this.forceField, this.speedField, this.vacuumField);
        if (operation == Operation.UNDEFINED) {
            operation = Operation.GRIP;
        }
        this.updateParameters(operation, dataModel, paramsDefinition);
    }

    private void updateParameters(Operation operation, ParamsDataModel dataModel, ParamsDefinition paramsDefinition) {
        if (paramsDefinition.isWidthDefined()) {
            WidthParam widthParam = paramsDefinition.getWidthParamDefinition();
            this.widthField.update((Length)widthParam.getMinValue(), (Length)widthParam.getMaxValue(), dataModel.getWidth());
        }
        if (paramsDefinition.isSpeedDefined()) {
            SpeedParam speedParam = paramsDefinition.getSpeedParamDefinition();
            this.speedField.update((Speed)speedParam.getMinValue(), (Speed)speedParam.getMaxValue(), dataModel.getSpeed());
        }
        if (operation == Operation.RELEASE) {
            if (this.forceField != null) {
                this.forceField.setVisible(false);
            }
            if (this.vacuumField != null) {
                this.vacuumField.setVisible(false);
            }
        } else {
            if (paramsDefinition.isForceDefined()) {
                GripForceParam forceParam = paramsDefinition.getForceParamDefinition();
                this.forceField.update((Force)forceParam.getMinValue(), (Force)forceParam.getMaxValue(), dataModel.getForce());
            }
            if (paramsDefinition.isVacuumDefined()) {
                GripVacuumParam vacuumParam = paramsDefinition.getVacuumParamDefinition();
                this.vacuumField.update((Pressure)vacuumParam.getMinValue(), (Pressure)vacuumParam.getMaxValue(), dataModel.getVacuum());
            }
        }
    }

    private void setEnablement(Operation operation, JComponent ... field) {
        JComponent[] jComponentArray = field;
        int n = field.length;
        int n2 = 0;
        while (n2 < n) {
            JComponent each = jComponentArray[n2];
            if (each != null) {
                each.setEnabled(operation != Operation.UNDEFINED);
            }
            ++n2;
        }
    }

    public void close() {
        this.payloadPanel.close();
    }
}

