/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.params.view;

import com.ur.polyscope.gripper.internal.gripper.common.widgets.DoubleValueConverter;
import com.ur.polyscope.gripper.internal.gripper.common.widgets.VOSlider;
import com.ur.polyscope.valueobjects.NumberValue;
import com.ur.swing.FormBuilder;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.ValueConverter;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidationFactory;
import com.ur.urcap.api.domain.userinteraction.inputvalidation.InputValidator;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class Slider<T extends NumberValue<?>>
extends JComponent {
    private final InputValidationFactory inputValidationFactory;
    private final ActionListener onTextChanged;
    private final ChangeListener onSliderChange;
    private final ValueConverter<String, T> valueConverter;
    private final JLabel label;
    private final VOSlider<T> valueAdjuster;
    private final NumberField numberField;
    private InputValidator<Double> validator;
    private T value;

    public Slider(String label, DoubleValueConverter<T> sliderValueConverter, ValueConverter<String, T> numberFieldConverter, InputValidationFactory inputValidationFactory) {
        this.inputValidationFactory = inputValidationFactory;
        this.valueConverter = numberFieldConverter;
        this.label = new JLabel(label);
        this.label.setFocusable(false);
        this.label.setPreferredSize(this.desiredWidthFromLanguage());
        this.onSliderChange = new UpdateTextOnSliderChange();
        this.valueAdjuster = new VOSlider<T>(sliderValueConverter);
        this.valueAdjuster.setValueObject(this.value);
        this.valueAdjuster.addChangeListener(this.onSliderChange);
        this.onTextChanged = new UpdateSliderWhenTextChanged();
        this.numberField = new NumberField(numberFieldConverter);
        this.numberField.addActionListener(this.onTextChanged);
        this.numberField.setUnitWidth(55);
        this.numberField.setColumns(7);
        this.numberField.setErrorValidationStrategy(new ValidationStrategy[]{new SliderValidationStrategy()});
    }

    private Dimension desiredWidthFromLanguage() {
        if (Locale.getDefault().equals(Locale.GERMAN) || Locale.getDefault().equals(new Locale("pl"))) {
            return new Dimension(120, 0);
        }
        return new Dimension(100, 0);
    }

    @Override
    public void setName(String name) {
        this.valueAdjuster.setName("slider" + name);
        this.numberField.setName("numberField" + name);
    }

    private void setValue(T value) {
        if (value == null) {
            return;
        }
        this.numberField.removeActionListener(this.onTextChanged);
        this.valueAdjuster.removeChangeListener(this.onSliderChange);
        try {
            this.value = value;
            this.numberField.setValue(value);
            this.valueAdjuster.setValueObject(value);
            this.numberField.forceValidation();
        }
        finally {
            this.numberField.addActionListener(this.onTextChanged);
            this.valueAdjuster.addChangeListener(this.onSliderChange);
        }
    }

    public T getValue() {
        return this.value;
    }

    private void setValueRange(T minimum, T maximum) {
        this.valueAdjuster.setValueRange(minimum, maximum);
        String formattedMin = this.valueConverter.getFormat().format(Double.valueOf((String)this.valueConverter.fromModel(minimum)));
        formattedMin = formattedMin.replace(",", ".");
        String formattedMax = this.valueConverter.getFormat().format(Double.valueOf((String)this.valueConverter.fromModel(maximum)));
        formattedMax = formattedMax.replace(",", ".");
        double validatorMin = Double.parseDouble(formattedMin);
        double validatorMax = Double.parseDouble(formattedMax);
        if (validatorMin >= 0.0 && validatorMax >= 0.0) {
            this.numberField.setMode(Mode.PositiveNumbers);
        } else {
            this.numberField.setMode(Mode.Standard);
        }
        this.validator = this.inputValidationFactory.createDoubleRangeValidator(validatorMin, validatorMax);
    }

    @Override
    public void setEnabled(boolean b) {
        this.label.setEnabled(b);
        this.valueAdjuster.setEnabled(b);
        this.numberField.setEnabled(b);
    }

    private void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ChangeListener.class) {
                ((ChangeListener)listeners[i + 1]).stateChanged(new ChangeEvent(this));
            }
            i -= 2;
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void doLayout(FormBuilder form) {
        form.component((JComponent)this.label, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component(this.valueAdjuster, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).component((JComponent)this.numberField, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.numberField.setVisible(visible);
        this.valueAdjuster.setVisible(visible);
        this.label.setVisible(visible);
    }

    public void update(T min, T max, T value) {
        this.setValueRange(min, max);
        this.setValue(value);
        this.setVisible(true);
    }

    class SliderValidationStrategy
    implements ValidationStrategy {
        private ValidationStrategy numberValidator = ValidationFactory.getNumberValidator();

        SliderValidationStrategy() {
        }

        public boolean isValid(String stringValue) {
            if (Slider.this.validator == null) {
                return true;
            }
            if (this.numberValidator.isValid(stringValue = stringValue.replace(",", "."))) {
                Double doubleValue = Double.valueOf((String)Slider.this.valueConverter.fromModel((Object)((NumberValue)Slider.this.valueConverter.fromGui((Object)stringValue))));
                return Slider.this.validator.isValid((Object)doubleValue);
            }
            return false;
        }

        public String getErrorMessage(String s) {
            if (!this.numberValidator.isValid(s)) {
                return this.numberValidator.getErrorMessage(s);
            }
            if (Slider.this.validator == null) {
                return "";
            }
            Double doubleValue = Double.valueOf((String)Slider.this.valueConverter.fromModel((Object)((NumberValue)Slider.this.valueConverter.fromGui((Object)s))));
            return Slider.this.validator.getMessage((Object)doubleValue);
        }
    }

    private class UpdateSliderWhenTextChanged
    implements ActionListener {
        private UpdateSliderWhenTextChanged() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Slider.this.valueAdjuster.removeChangeListener(Slider.this.onSliderChange);
                try {
                    Slider.this.value = (NumberValue)Slider.this.numberField.getValue();
                    Slider.this.valueAdjuster.setValueObject(Slider.this.value);
                    Slider.this.fireStateChanged();
                }
                catch (NumberFormatException numberFormatException) {}
            }
            finally {
                Slider.this.valueAdjuster.addChangeListener(Slider.this.onSliderChange);
            }
        }
    }

    private class UpdateTextOnSliderChange
    implements ChangeListener {
        private UpdateTextOnSliderChange() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object source;
            if (Slider.this.isEnabled() && (source = e.getSource()) == Slider.this.valueAdjuster) {
                this.onSliderChanged();
            }
        }

        private void onSliderChanged() {
            Slider.this.numberField.removeActionListener(Slider.this.onTextChanged);
            try {
                Slider.this.value = Slider.this.valueAdjuster.getValueObject();
                Slider.this.numberField.setValue((Object)Slider.this.value);
                if (!Slider.this.valueAdjuster.getValueIsAdjusting()) {
                    Slider.this.fireStateChanged();
                }
            }
            finally {
                Slider.this.numberField.addActionListener(Slider.this.onTextChanged);
            }
        }
    }
}

