/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.params.view;

import com.ur.polyscope.gripper.internal.gripper.common.widgets.DoubleValueConverter;
import com.ur.polyscope.valueobjects.Force;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.Pressure;
import com.ur.polyscope.valueobjects.Speed;
import com.ur.urcap.api.domain.value.simple.Force;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.Pressure;
import com.ur.urcap.api.domain.value.simple.Speed;

public final class URCapAPIValueConverters {
    public static final DoubleValueConverter<Pressure> PRESSURE_CONVERTER = new DoubleValueConverter<Pressure>(){

        @Override
        public double asDouble(Pressure value) {
            return value.getAs(Pressure.Unit.KPA);
        }

        @Override
        public Pressure valueOf(double value) {
            return Pressure.from((double)value, (Pressure.Unit)Pressure.Unit.KPA);
        }
    };
    public static final DoubleValueConverter<Force> FORCE_CONVERTER = new DoubleValueConverter<Force>(){

        @Override
        public double asDouble(Force value) {
            return value.getAs(Force.Unit.N);
        }

        @Override
        public Force valueOf(double value) {
            return Force.from((double)value, (Force.Unit)Force.Unit.N);
        }
    };
    public static final DoubleValueConverter<Speed> SPEED_CONVERTER = new DoubleValueConverter<Speed>(){

        @Override
        public double asDouble(Speed value) {
            return value.getAs(Speed.Unit.MM_S);
        }

        @Override
        public Speed valueOf(double value) {
            return Speed.from((double)value, (Speed.Unit)Speed.Unit.MM_S);
        }
    };
    public static final DoubleValueConverter<Length> LENGTH_CONVERTER = new DoubleValueConverter<Length>(){

        @Override
        public double asDouble(Length value) {
            return value.getAs(Length.Unit.MM);
        }

        @Override
        public Length valueOf(double value) {
            return (Length)Length.from((double)value, (Length.Unit)Length.Unit.MM);
        }
    };

    private URCapAPIValueConverters() {
    }
}

