/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.program;

import com.ur.polyscope.gripper.internal.gripper.GripperContext;
import com.ur.polyscope.gripper.internal.gripper.params.GripForceParam;
import com.ur.polyscope.gripper.internal.gripper.params.GripVacuumParam;
import com.ur.polyscope.gripper.internal.gripper.params.Operation;
import com.ur.polyscope.gripper.internal.gripper.params.Param;
import com.ur.polyscope.gripper.internal.gripper.params.ParamsDefinition;
import com.ur.polyscope.gripper.internal.gripper.params.SpeedParam;
import com.ur.polyscope.gripper.internal.gripper.params.WidthParam;
import com.ur.polyscope.gripper.internal.gripper.program.GripperDataModel;
import com.ur.polyscope.gripper.internal.gripper.program.GripperDataModelConstants;
import com.ur.polyscope.gripper.internal.gripper.program.GripperDataModelConverter;
import com.ur.polyscope.gripper.internal.gripper.program.PrefixDataModel;
import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadConstants;
import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadNotSelected;
import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadWithMassOnly;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.NumberValue;
import com.ur.polyscope.valueobjects.Pressure;
import com.ur.urcap.api.contribution.program.CreationContext;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.payload.Payload;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.SelectableGripper;
import com.ur.urcap.api.domain.value.simple.Force;
import com.ur.urcap.api.domain.value.simple.Mass;
import com.ur.urcap.api.domain.value.simple.Speed;

public class GripperDataModelImpl
implements GripperDataModel {
    private final DataModel model;
    private final DataModel gripDataModel;
    private final DataModel releaseDataModel;
    private final GripperContext gripperContext;
    private final boolean feedbackEnabledByDefault;
    private volatile boolean requireConversion;
    private DataModel activeModel;

    public GripperDataModelImpl(DataModel model, GripperContext gripperContext, CreationContext.NodeCreationType creationType) {
        this.model = model;
        this.gripDataModel = PrefixDataModel.createProxy("GRIP", model);
        this.releaseDataModel = PrefixDataModel.createProxy("RELEASE", model);
        this.activeModel = this.selectActiveModel(this.getOperation());
        this.gripperContext = gripperContext;
        this.feedbackEnabledByDefault = creationType == CreationContext.NodeCreationType.NEW;
        this.requireConversion = this.getOperation() != Operation.UNDEFINED && creationType == CreationContext.NodeCreationType.LOAD;
    }

    private DataModel selectActiveModel(Operation operation) {
        if (operation == Operation.UNDEFINED) {
            return this.model;
        }
        if (operation == Operation.GRIP) {
            return this.gripDataModel;
        }
        return this.releaseDataModel;
    }

    ParamsDefinition getParamDef() {
        SelectableGripper selectedGripper = this.gripperContext.getGripperById(this.getGripperId());
        return selectedGripper == null ? this.gripperContext.getParamsDefinition() : this.gripperContext.getParamsDefinition(selectedGripper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void convertDataModelIfRequired() {
        if (!this.requireConversion) {
            return;
        }
        GripperDataModelImpl gripperDataModelImpl = this;
        synchronized (gripperDataModelImpl) {
            if (!this.requireConversion) {
                return;
            }
            this.requireConversion = false;
            GripperDataModelConverter converter = new GripperDataModelConverter(this);
            converter.convertDataModel(this.model);
        }
    }

    @Override
    public Operation getOperation() {
        this.convertDataModelIfRequired();
        String operationName = this.model.get("OPERATION", Operation.UNDEFINED.name());
        return Operation.valueOf(operationName);
    }

    @Override
    public void setOperation(Operation toOperation) {
        this.convertDataModelIfRequired();
        if (toOperation == this.getOperation()) {
            return;
        }
        if (toOperation == Operation.UNDEFINED) {
            this.model.remove("OPERATION");
            this.activeModel = this.model;
            return;
        }
        this.activeModel = this.selectActiveModel(toOperation);
        this.model.set("OPERATION", toOperation.name());
        this.applyDefaultWidth(toOperation);
        this.applyDefaultSpeed(toOperation);
        this.applyDefaultForce(toOperation);
        this.applyDefaultVacuum(toOperation);
    }

    private void applyDefaultVacuum(Operation operation) {
        GripVacuumParam param;
        if (this.getParamDef().isVacuumDefined() && operation == Operation.GRIP && !this.isParamDataModelKeySet((param = this.getParamDef().getVacuumParamDefinition()).getDataModelKey())) {
            this.setVacuum((Pressure)param.getDefaultValue(operation));
        }
    }

    private void applyDefaultForce(Operation operation) {
        GripForceParam param;
        if (this.getParamDef().isForceDefined() && operation == Operation.GRIP && !this.isParamDataModelKeySet((param = this.getParamDef().getForceParamDefinition()).getDataModelKey())) {
            this.setForce((com.ur.polyscope.valueobjects.Force)param.getDefaultValue(operation));
        }
    }

    private void applyDefaultSpeed(Operation operation) {
        SpeedParam param;
        if (this.getParamDef().isSpeedDefined() && !this.isParamDataModelKeySet((param = this.getParamDef().getSpeedParamDefinition()).getDataModelKey())) {
            this.setSpeed((com.ur.polyscope.valueobjects.Speed)param.getDefaultValue(operation));
        }
    }

    private void applyDefaultWidth(Operation operation) {
        WidthParam param;
        if (this.getParamDef().isWidthDefined() && !this.isParamDataModelKeySet((param = this.getParamDef().getWidthParamDefinition()).getDataModelKey())) {
            this.setWidth((Length)param.getDefaultValue(operation));
        }
    }

    @Override
    public String getGripperId() {
        this.convertDataModelIfRequired();
        return this.model.get("SELECTED_GRIPPER_ID", null);
    }

    @Override
    public String getGripperName() {
        this.convertDataModelIfRequired();
        return this.model.get("SELECTED_GRIPPER_NAME", null);
    }

    @Override
    public void setSelectableGripper(SelectableGripper value) {
        this.convertDataModelIfRequired();
        if (value == null) {
            this.model.remove("SELECTED_GRIPPER_ID");
            this.model.remove("SELECTED_GRIPPER_NAME");
        } else {
            this.model.set("SELECTED_GRIPPER_ID", value.getId());
            this.model.set("SELECTED_GRIPPER_NAME", value.toString());
        }
    }

    @Override
    public Length getWidth() {
        this.convertDataModelIfRequired();
        WidthParam param = this.getParamDef().getWidthParamDefinition();
        if (param == null) {
            return null;
        }
        Operation operation = this.getOperation();
        Length defaultValue = (Length)param.getDefaultValue(operation);
        return (Length)this.activeModel.get("WIDTH", (com.ur.urcap.api.domain.value.simple.Length)defaultValue);
    }

    @Override
    public void setWidth(Length value) {
        this.convertDataModelIfRequired();
        WidthParam param = this.getParamDef().getWidthParamDefinition();
        if (param == null) {
            return;
        }
        this.activeModel.set("WIDTH", (com.ur.urcap.api.domain.value.simple.Length)value);
    }

    @Override
    public com.ur.polyscope.valueobjects.Force getForce() {
        this.convertDataModelIfRequired();
        GripForceParam param = this.getParamDef().getForceParamDefinition();
        if (param == null) {
            return null;
        }
        Operation operation = this.getOperation();
        com.ur.polyscope.valueobjects.Force defaultValue = (com.ur.polyscope.valueobjects.Force)param.getDefaultValue(operation);
        return (com.ur.polyscope.valueobjects.Force)this.activeModel.get("FORCE", (Force)defaultValue);
    }

    @Override
    public void setForce(com.ur.polyscope.valueobjects.Force value) {
        this.convertDataModelIfRequired();
        GripForceParam param = this.getParamDef().getForceParamDefinition();
        if (param == null) {
            return;
        }
        this.activeModel.set("FORCE", (Force)value);
    }

    @Override
    public Pressure getVacuum() {
        this.convertDataModelIfRequired();
        GripVacuumParam param = this.getParamDef().getVacuumParamDefinition();
        if (param == null) {
            return null;
        }
        Operation operation = this.getOperation();
        Pressure defaultValue = (Pressure)param.getDefaultValue(operation);
        return (Pressure)this.activeModel.get("VACUUM", (com.ur.urcap.api.domain.value.simple.Pressure)defaultValue);
    }

    @Override
    public void setVacuum(Pressure value) {
        this.convertDataModelIfRequired();
        GripVacuumParam param = this.getParamDef().getVacuumParamDefinition();
        if (param == null) {
            return;
        }
        this.activeModel.set("VACUUM", (com.ur.urcap.api.domain.value.simple.Pressure)value);
    }

    @Override
    public com.ur.polyscope.valueobjects.Speed getSpeed() {
        this.convertDataModelIfRequired();
        SpeedParam param = this.getParamDef().getSpeedParamDefinition();
        if (param == null) {
            return null;
        }
        Operation operation = this.getOperation();
        com.ur.polyscope.valueobjects.Speed defaultValue = (com.ur.polyscope.valueobjects.Speed)param.getDefaultValue(operation);
        return (com.ur.polyscope.valueobjects.Speed)this.activeModel.get("SPEED", (Speed)defaultValue);
    }

    @Override
    public void setSpeed(com.ur.polyscope.valueobjects.Speed value) {
        this.convertDataModelIfRequired();
        SpeedParam param = this.getParamDef().getSpeedParamDefinition();
        if (param == null) {
            return;
        }
        this.activeModel.set("SPEED", (Speed)value);
    }

    @Override
    public void setFeedbackDetectionEnabled(boolean enabled) {
        this.convertDataModelIfRequired();
        this.model.set("ToggleGripReleaseDetection", enabled);
    }

    @Override
    public boolean isFeedbackDetectionEnabled() {
        this.convertDataModelIfRequired();
        return this.model.get("ToggleGripReleaseDetection", this.feedbackEnabledByDefault);
    }

    private boolean isParamDataModelKeySet(String key) {
        return this.activeModel.isSet(key);
    }

    @Override
    public boolean isUsePayload() {
        this.convertDataModelIfRequired();
        return this.activeModel.get("usePayload", true);
    }

    @Override
    public void setUsePayload(boolean usePayload) {
        this.convertDataModelIfRequired();
        if (this.getOperation() == Operation.UNDEFINED) {
            return;
        }
        this.activeModel.set("usePayload", usePayload);
    }

    public GripperDataModelConstants.PayloadType getPayloadType() {
        this.convertDataModelIfRequired();
        String name = this.activeModel.get("payloadType", GripperDataModelConstants.PayloadType.UNDEFINED_PAYLOAD.name());
        return GripperDataModelConstants.PayloadType.valueOf(name);
    }

    public void setPayloadType(GripperDataModelConstants.PayloadType type) {
        this.convertDataModelIfRequired();
        if (this.getOperation() == Operation.UNDEFINED) {
            return;
        }
        this.activeModel.set("payloadType", type.name());
    }

    public Mass getPayloadMass() {
        this.convertDataModelIfRequired();
        return this.activeModel.get("payloadMass", PayloadConstants.EMPTY_MASS);
    }

    public void setPayloadMass(Mass mass) {
        this.convertDataModelIfRequired();
        if (this.getOperation() == Operation.UNDEFINED) {
            return;
        }
        this.activeModel.set("payloadMass", mass);
    }

    @Override
    public Payload getPayload() {
        Object payload;
        this.convertDataModelIfRequired();
        GripperDataModelConstants.PayloadType type = this.getPayloadType();
        switch (type) {
            case MASS_PAYLOAD: {
                Mass mass = this.getPayloadMass();
                payload = new PayloadWithMassOnly(mass);
                break;
            }
            case ENTITY_PAYLOAD: {
                payload = this.activeModel.get("payload", (Payload)new PayloadNotSelected());
                break;
            }
            default: {
                payload = new PayloadNotSelected();
            }
        }
        return payload;
    }

    @Override
    public void setPayload(Payload payload) {
        this.convertDataModelIfRequired();
        if (payload instanceof PayloadNotSelected) {
            this.setPayloadType(GripperDataModelConstants.PayloadType.UNDEFINED_PAYLOAD);
        } else if (payload instanceof PayloadWithMassOnly) {
            this.setPayloadType(GripperDataModelConstants.PayloadType.MASS_PAYLOAD);
            this.setPayloadMass(payload.getMass());
            this.activeModel.remove("payload");
        } else {
            this.setPayloadType(GripperDataModelConstants.PayloadType.ENTITY_PAYLOAD);
            this.activeModel.set("payload", payload);
        }
    }

    @Override
    public boolean isValid() {
        this.convertDataModelIfRequired();
        if (!this.isPayloadValid()) {
            return false;
        }
        return GripperDataModelImpl.isValid(this.getParamDef().getWidthParamDefinition(), this.getWidth()) && GripperDataModelImpl.isValid(this.getParamDef().getSpeedParamDefinition(), this.getSpeed()) && GripperDataModelImpl.isValid(this.getParamDef().getForceParamDefinition(), this.getForce()) && GripperDataModelImpl.isValid(this.getParamDef().getVacuumParamDefinition(), this.getVacuum());
    }

    @Override
    public boolean isPayloadValid() {
        if (!this.isUsePayload()) {
            return true;
        }
        Payload payload = this.getPayload();
        if (!payload.isResolvable()) {
            return false;
        }
        if (!payload.isUsable()) {
            return false;
        }
        Mass mass = payload.getMass();
        return !this.isUsePayload() || !PayloadConstants.isEmpty(mass);
    }

    private static <T extends NumberValue<?>> boolean isValid(Param<T> param, T value) {
        return param == null || GripperDataModelImpl.isValidValue(param, value);
    }

    private static <T extends NumberValue<?>> boolean isValidValue(Param<T> param, T value) {
        double v = value.asDouble();
        return ((NumberValue)param.getMinValue()).asDouble() <= v && v <= ((NumberValue)param.getMaxValue()).asDouble();
    }
}

