/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.program;

import com.ur.polyscope.gripper.internal.gripper.device.GripperDeviceProvider;
import com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution;
import com.ur.polyscope.gripper.internal.gripper.program.config.UndefinedActionConfigBuilder;
import com.ur.polyscope.gripper.internal.gripper.program.config.UndefinedConfigBuilderFactory;
import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadConstants;
import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadNotSelected;
import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadWithMassOnly;
import com.ur.urcap.api.contribution.driver.gripper.conformant.GripperNodeConfigBuilders;
import com.ur.urcap.api.domain.device.gripper.GripperDevice;
import com.ur.urcap.api.domain.payload.Payload;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.GripActionConfigBuilder;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.GripperNodeConfig;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.ReleaseActionConfigBuilder;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.SelectableGripper;
import com.ur.urcap.api.domain.value.simple.Mass;
import com.ur.urcap.api.util.Optional;

public class GripperNodeConfigExtractor {
    public GripperNodeConfig extract(ProxyProgramNodeContribution node, GripperNodeConfigBuilders gripperNodeConfigBuilders) {
        GripperNodeConfig gripperNodeConfig;
        Optional<SelectableGripper> gripperSelection = node.getGripperSelection();
        switch (node.getOperation()) {
            case GRIP: {
                gripperNodeConfig = this.buildGripNodeConfig(node, gripperNodeConfigBuilders, gripperSelection);
                break;
            }
            case RELEASE: {
                gripperNodeConfig = this.buildReleaseNodeConfig(node, gripperNodeConfigBuilders, gripperSelection);
                break;
            }
            case UNDEFINED: {
                gripperNodeConfig = this.buildUndefinedNodeConfig(node, gripperNodeConfigBuilders, gripperSelection);
                break;
            }
            default: {
                gripperNodeConfig = gripperNodeConfigBuilders.createUndefinedConfig();
            }
        }
        if (gripperNodeConfig instanceof GripperDeviceProvider) {
            GripperDevice device = node.getGripperDevice();
            GripperDeviceProvider gripperDeviceProvider = (GripperDeviceProvider)gripperNodeConfig;
            gripperDeviceProvider.setGripperDevice(device);
        }
        return gripperNodeConfig;
    }

    private GripperNodeConfig buildGripNodeConfig(ProxyProgramNodeContribution node, GripperNodeConfigBuilders gripperNodeConfigBuilders, Optional<SelectableGripper> gripperSelection) {
        GripActionConfigBuilder builder = gripperNodeConfigBuilders.createGripActionConfigBuilder();
        if (node.isMultiGripper()) {
            builder.setGripperSelection(gripperSelection);
        }
        if (!node.isUsePayload()) {
            builder.setPayloadSettingDisabled();
        } else {
            this.buildGripPayload(node, builder);
        }
        return builder.build();
    }

    private void buildGripPayload(ProxyProgramNodeContribution node, GripActionConfigBuilder builder) {
        Payload payload = node.getPayload();
        if (!(payload instanceof PayloadNotSelected)) {
            if (payload instanceof PayloadWithMassOnly) {
                Mass mass = payload.getMass();
                if (PayloadConstants.isEmpty(mass)) {
                    builder.setEmptyPayloadMass();
                } else {
                    builder.setPayloadMass(mass);
                }
            } else {
                builder.setPayloadSelection(payload);
            }
        }
    }

    private GripperNodeConfig buildReleaseNodeConfig(ProxyProgramNodeContribution node, GripperNodeConfigBuilders gripperNodeConfigBuilders, Optional<SelectableGripper> gripperSelection) {
        ReleaseActionConfigBuilder builder = gripperNodeConfigBuilders.createReleaseActionConfigBuilder();
        if (node.isMultiGripper()) {
            builder.setGripperSelection(gripperSelection);
        }
        if (!node.isUsePayload()) {
            builder.setPayloadSettingDisabled();
        } else {
            this.buildReleasePayload(node, builder);
        }
        return builder.build();
    }

    private void buildReleasePayload(ProxyProgramNodeContribution node, ReleaseActionConfigBuilder builder) {
        Payload payload = node.getPayload();
        if (!(payload instanceof PayloadNotSelected)) {
            if (payload instanceof PayloadWithMassOnly) {
                Mass mass = payload.getMass();
                if (PayloadConstants.isEmpty(mass)) {
                    builder.setEmptyPayloadMass();
                } else {
                    builder.setPayloadMass(mass);
                }
            } else {
                builder.setPayloadSelection(payload);
            }
        }
    }

    private GripperNodeConfig buildUndefinedNodeConfig(ProxyProgramNodeContribution node, GripperNodeConfigBuilders gripperNodeConfigBuilders, Optional<SelectableGripper> gripperSelection) {
        UndefinedConfigBuilderFactory builder = (UndefinedConfigBuilderFactory)gripperNodeConfigBuilders;
        UndefinedActionConfigBuilder undefinedActionConfigBuilder = builder.createUndefinedConfigBuilder();
        if (node.isMultiGripper()) {
            undefinedActionConfigBuilder.setGripperSelection(gripperSelection);
        }
        return undefinedActionConfigBuilder.build();
    }
}

