/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.program;

import com.ur.polyscope.gripper.internal.gripper.GripperContext;
import com.ur.polyscope.gripper.internal.gripper.params.GripperParam;
import com.ur.polyscope.gripper.internal.gripper.program.GripperAction;
import com.ur.polyscope.gripper.internal.gripper.program.ProgramActions;
import com.ur.polyscope.gripper.internal.gripper.program.ProgramGripperComboBoxModel;
import com.ur.polyscope.gripper.resource.internal.TextResource;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.SelectableGripper;
import com.ur.util.swing.HTML;
import java.awt.CardLayout;
import java.awt.Component;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MultiGripperSelectionPanel {
    private static final String COMBOBOX = "MultiGripperSelectionPanel.ComboBox";
    private final TextResource textResource;
    private final WidgetFactory widgetFactory;
    private GripperContext gripperContext;
    private JLabel singleEnabledGripperName;
    private JComboBox gripperComboBox;
    private ProgramGripperComboBoxModel gripperComboBoxModel;
    private GripperAction gripperAction;

    @Inject
    public MultiGripperSelectionPanel(ViewContext viewContext) {
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.widgetFactory = viewContext.createWidgetFactory();
    }

    public void buildUI(ProgramActions actions, GripperContext gripperContext, FormBuilder formBuilder) {
        this.gripperContext = gripperContext;
        if (!gripperContext.isMultiGripper()) {
            return;
        }
        JPanel gripperSelection = new JPanel(new CardLayout());
        gripperSelection.setBorder(BorderFactory.createEmptyBorder());
        this.gripperComboBox = this.widgetFactory.createComboBox();
        this.gripperComboBox.setName(COMBOBOX);
        this.gripperComboBoxModel = new ProgramGripperComboBoxModel(gripperContext, this.textResource.selectGripper());
        this.gripperComboBox.setModel(this.gripperComboBoxModel);
        this.gripperAction = new GripperAction(this.gripperComboBox, actions);
        this.singleEnabledGripperName = this.widgetFactory.createLabel("");
        this.singleEnabledGripperName.setVisible(false);
        this.singleEnabledGripperName.setBorder(BorderFactory.createEtchedBorder());
        gripperSelection.add((Component)this.singleEnabledGripperName, "just-text");
        gripperSelection.add((Component)this.gripperComboBox, "combo-box");
        formBuilder.label(HTML.fontBold((String)this.textResource.gripper()), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end();
        formBuilder.component((JComponent)gripperSelection, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end();
    }

    public void initialize(GripperParam gripperParam) {
        boolean showGripperText;
        if (!this.gripperContext.isMultiGripper()) {
            return;
        }
        this.gripperComboBox.removeItemListener(this.gripperAction);
        this.gripperComboBoxModel.reloadElements(this.selectGripper(gripperParam));
        this.gripperComboBox.addItemListener(this.gripperAction);
        boolean showGripperName = this.gripperContext.isOnlyOneGripperAvailable() && this.gripperContext.isValidGripperSelected(gripperParam) && gripperParam.getValue() != null;
        boolean showNoGrippers = this.gripperContext.getGrippersEnabled().isEmpty();
        boolean bl = showGripperText = showGripperName || showNoGrippers;
        if (this.gripperContext.isSelectedGripperDisabled(gripperParam)) {
            showGripperText = false;
        }
        if (showGripperName) {
            this.singleEnabledGripperName.setText(gripperParam.getValue().toString());
        } else if (showNoGrippers) {
            this.singleEnabledGripperName.setText(this.textResource.noGrippers());
        }
        this.singleEnabledGripperName.setVisible(showGripperText);
        this.gripperComboBox.setVisible(!showGripperText);
    }

    private Object selectGripper(GripperParam gripperParam) {
        SelectableGripper value = gripperParam.getValue();
        if (value == null) {
            return this.textResource.selectGripper();
        }
        return value;
    }
}

