/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.program;

import com.ur.polyscope.gripper.internal.gripper.params.GripForceParam;
import com.ur.polyscope.gripper.internal.gripper.params.GripVacuumParam;
import com.ur.polyscope.gripper.internal.gripper.params.Operation;
import com.ur.polyscope.gripper.internal.gripper.params.SpeedParam;
import com.ur.polyscope.gripper.internal.gripper.params.WidthParam;
import com.ur.polyscope.gripper.internal.gripper.program.DataModelConverter;
import com.ur.polyscope.gripper.internal.gripper.program.GripperDataModelImpl;
import com.ur.polyscope.valueobjects.Force;
import com.ur.polyscope.valueobjects.Length;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.value.simple.Pressure;
import com.ur.urcap.api.domain.value.simple.Speed;
import java.util.Set;

public class ParamsConverter
implements DataModelConverter {
    private final GripperDataModelImpl gripperDataModel;

    public ParamsConverter(GripperDataModelImpl gripperDataModel) {
        this.gripperDataModel = gripperDataModel;
    }

    @Override
    public void convertDataModel(DataModel model) {
        WidthParam widthParamDefinition;
        GripVacuumParam vacuumParamDefinition;
        SpeedParam speedParamDefinition;
        if (!this.isParamsConversionRequired(model)) {
            return;
        }
        GripForceParam forceParamDefinition = this.gripperDataModel.getParamDef().getForceParamDefinition();
        if (forceParamDefinition != null) {
            com.ur.urcap.api.domain.value.simple.Force force = model.get("FORCE", null);
            this.gripperDataModel.setForce((Force)force);
            model.remove("FORCE");
        }
        if ((speedParamDefinition = this.gripperDataModel.getParamDef().getSpeedParamDefinition()) != null) {
            Speed speed = model.get("SPEED", null);
            this.gripperDataModel.setSpeed((com.ur.polyscope.valueobjects.Speed)speed);
            model.remove("SPEED");
        }
        if ((vacuumParamDefinition = this.gripperDataModel.getParamDef().getVacuumParamDefinition()) != null) {
            Pressure pressure = model.get("VACUUM", null);
            this.gripperDataModel.setVacuum((com.ur.polyscope.valueobjects.Pressure)pressure);
            model.remove("VACUUM");
        }
        if ((widthParamDefinition = this.gripperDataModel.getParamDef().getWidthParamDefinition()) != null) {
            com.ur.urcap.api.domain.value.simple.Length length = model.get("WIDTH", null);
            this.gripperDataModel.setWidth((Length)length);
            model.remove("WIDTH");
        }
        model.set(String.valueOf(Operation.GRIP.name()) + "." + "usePayload", false);
        model.set(String.valueOf(Operation.RELEASE.name()) + "." + "usePayload", false);
    }

    public boolean isParamsConversionRequired(DataModel model) {
        Set keys = model.getKeys();
        String gripPrefix = String.valueOf(Operation.GRIP.name()) + ".";
        String releasePrefix = String.valueOf(Operation.RELEASE.name()) + ".";
        for (String s : keys) {
            if (!s.startsWith(gripPrefix) && !s.startsWith(releasePrefix)) continue;
            return false;
        }
        return true;
    }
}

