/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.program;

import com.ur.polyscope.gripper.internal.gripper.params.Operation;
import com.ur.polyscope.gripper.internal.gripper.program.actions.GripperProgramNode;
import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadConstants;
import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadNotSelected;
import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadWithMassOnly;
import com.ur.polyscope.gripper.internal.resources.ImageResource;
import com.ur.polyscope.payload.TextResource;
import com.ur.polyscope.payload.common.PayloadValidationRules;
import com.ur.polyscope.robot.configuration.RobotConfigurationProvider;
import com.ur.polyscope.robot.configuration.RobotPayload;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.units.ValueConverter;
import com.ur.urcap.api.domain.payload.Payload;
import com.ur.urcap.api.domain.value.Position;
import com.ur.urcap.api.domain.value.dynamics.InertiaMatrix;
import com.ur.urcap.api.domain.value.simple.Mass;
import com.ur.util.swing.HTML;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class PayloadWarningPanel {
    public static final String WARNING_NAME = "payloadWarning";
    private static RobotPayload robotPayload;
    private final TextResource textResource;
    private final ViewContext viewContext;
    private final PayloadValidationRules payloadValidationRules;
    private String rememberPayloadWarning;
    private String combinedMassAndCogWarning;
    private String payloadExceededWarning;
    private String errorInInstallationPayloadMsg;
    private Provider<GripperProgramNode> provider;
    private JLabel warningLabel;

    @Inject
    public PayloadWarningPanel(ViewContext viewContext, PayloadValidationRules payloadValidationRules, TextResource textResource) {
        this.viewContext = viewContext;
        this.textResource = textResource;
        this.payloadValidationRules = payloadValidationRules;
    }

    @Inject
    public static void setRobotPayload(RobotConfigurationProvider robotConfigurationProvider) {
        robotPayload = robotConfigurationProvider.getRobotPayload();
    }

    public void buildUI(Provider<GripperProgramNode> provider, FormBuilder formBuilder) {
        this.provider = provider;
        ValueConverter weightConverter = UnitsValueConverterFactory.getWeightConverter();
        Weight maxPayloadSoftLimitSI = Weight.from((double)robotPayload.getMaximumPayload(false).asDouble(), (Weight.Unit)Weight.Unit.SI);
        String maxPayloadConverted = weightConverter.getFormat().format(Double.parseDouble((String)weightConverter.fromModel((Object)maxPayloadSoftLimitSI)));
        String unit = weightConverter.getUnit();
        this.combinedMassAndCogWarning = HTML.html((String)HTML.p((String)HTML.fontSize((String)"4", (String)this.textResource.payloadCogComboAffectPerformanceWarning())));
        this.rememberPayloadWarning = HTML.html((String)HTML.p((String)HTML.fontSize((String)"4", (String)this.textResource.rememberPayloadWarning())));
        this.payloadExceededWarning = HTML.html((String)HTML.p((String)HTML.fontSize((String)"4", (String)this.textResource.ratedpPayloadExceeded(maxPayloadConverted, unit))));
        this.errorInInstallationPayloadMsg = HTML.html((String)HTML.p((String)HTML.fontSize((String)"4", (String)this.textResource.payloadHasErrorInInstallation())));
        WidgetFactory wf = this.viewContext.createWidgetFactory();
        this.warningLabel = wf.createLabel("");
        this.warningLabel.setIcon(ImageResource.warning());
        this.warningLabel.setName(WARNING_NAME);
        formBuilder.component((JComponent)this.warningLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS});
    }

    private void updateWarningLabel(Payload payload) {
        if (!payload.isResolvable()) {
            this.warningLabel.setVisible(false);
            return;
        }
        this.updateWarningLabelForResolvedPayload(payload);
    }

    private void updateWarningLabelForResolvedPayload(Payload payload) {
        Weight mass = (Weight)payload.getMass();
        Position cog = payload.getCenterOfGravity();
        InertiaMatrix inertiaMatrix = payload.getInertiaMatrix();
        boolean showWarning = false;
        boolean showError = false;
        String text = "";
        if (PayloadConstants.isEmpty((Mass)mass) || this.payloadValidationRules.isMassZero((Mass)mass)) {
            text = this.rememberPayloadWarning;
            showWarning = true;
        } else if (this.payloadValidationRules.isMassAboveUpperSoftLimit((Mass)mass)) {
            text = this.payloadExceededWarning;
            showWarning = true;
        } else if (this.isPayloadWithCog(payload) && !this.payloadValidationRules.isMassAndCOGValid((Mass)mass, cog)) {
            text = this.combinedMassAndCogWarning;
            showWarning = true;
        } else if (this.isPayloadWithCog(payload) && !this.payloadValidationRules.isMassAndCOGAndInertiaValid((Mass)mass, cog, inertiaMatrix)) {
            text = this.errorInInstallationPayloadMsg;
            showError = true;
        }
        this.warningLabel.setText(text);
        Icon icon = showError ? ImageResource.error() : ImageResource.warning();
        this.warningLabel.setIcon(icon);
        this.warningLabel.setVisible(showWarning || showError);
    }

    private boolean isPayloadWithCog(Payload payload) {
        return !(payload instanceof PayloadWithMassOnly) && !(payload instanceof PayloadNotSelected);
    }

    public void initialize(Operation operation) {
        if (operation == Operation.UNDEFINED) {
            this.warningLabel.setVisible(false);
        } else {
            GripperProgramNode programNode = (GripperProgramNode)this.provider.get();
            Payload payload = programNode.getPayload();
            if (payload instanceof PayloadNotSelected) {
                this.warningLabel.setVisible(false);
            } else {
                this.updateWarningLabel(payload);
            }
        }
    }
}

