/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.program;

import com.ur.polyscope.gripper.internal.gripper.params.Operation;
import com.ur.polyscope.gripper.internal.gripper.program.DataModelConverter;
import com.ur.polyscope.gripper.internal.gripper.program.GripperDataModelConstants;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.value.simple.Mass;

public class PayloadWeightToMassConverter
implements DataModelConverter {
    public static final String PAYLOAD_WEIGHT = "payloadWeight";

    @Override
    public void convertDataModel(DataModel model) {
        this.convertMass(model, Operation.GRIP);
        this.convertMass(model, Operation.RELEASE);
    }

    private void convertMass(DataModel model, Operation operation) {
        String prefix = String.valueOf(operation.name()) + ".";
        if (model.getKeys().contains(String.valueOf(prefix) + PAYLOAD_WEIGHT)) {
            double weight = model.get(String.valueOf(prefix) + PAYLOAD_WEIGHT, Double.POSITIVE_INFINITY);
            Weight mass = Weight.from((double)weight, (Weight.Unit)Weight.Unit.KG);
            model.set(String.valueOf(prefix) + "payloadMass", (Mass)mass);
            model.set(String.valueOf(prefix) + "payloadType", GripperDataModelConstants.PayloadType.MASS_PAYLOAD.name());
            model.remove(String.valueOf(prefix) + PAYLOAD_WEIGHT);
        }
    }
}

