/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.program;

import com.ur.urcap.api.domain.data.DataModel;
import com.ur.util.logging.Log;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public final class PrefixDataModel {
    public static final String GET_KEYS = "getKeys";

    private PrefixDataModel() {
    }

    public static DataModel createProxy(String prefix, DataModel wrappedDataModel) {
        return (DataModel)Proxy.newProxyInstance(DataModel.class.getClassLoader(), new Class[]{DataModel.class}, (InvocationHandler)new DataModelInvocationHandler(prefix, wrappedDataModel));
    }

    private static class DataModelInvocationHandler
    implements InvocationHandler {
        private String prefix;
        private DataModel wrappedDataModel;

        public DataModelInvocationHandler(String prefix, DataModel wrappedDataModel) {
            this.prefix = prefix;
            this.wrappedDataModel = wrappedDataModel;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) {
            if (method.getName().equals(PrefixDataModel.GET_KEYS)) {
                return this.wrappedDataModel.getKeys();
            }
            try {
                String originalKey = (String)objects[0];
                objects[0] = String.valueOf(this.prefix) + "." + originalKey;
                return method.invoke((Object)this.wrappedDataModel, objects);
            }
            catch (IllegalAccessException e) {
                Log.error((String)"Method is not public", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Log.error((String)"Bad target", (Throwable)e);
            }
            return null;
        }
    }
}

