/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.program;

import com.ur.polyscope.gripper.internal.gripper.params.ActionParameters;
import com.ur.polyscope.gripper.internal.gripper.params.Actions;
import com.ur.polyscope.gripper.internal.gripper.params.Operation;
import com.ur.polyscope.gripper.internal.gripper.params.SetParamProviders;
import com.ur.polyscope.gripper.internal.gripper.params.usecases.AdjustParameterValue;
import com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution;
import com.ur.polyscope.valueobjects.Force;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.Pressure;
import com.ur.polyscope.valueobjects.Speed;
import com.ur.urcap.api.contribution.ContributionProvider;
import com.ur.urcap.api.contribution.driver.gripper.GripperContribution;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.SelectableGripper;
import com.ur.urcap.api.domain.script.ScriptWriter;

public class ProgramActions
extends Actions
implements SetParamProviders {
    private ContributionProvider<ProxyProgramNodeContribution> contributionProvider;

    public ProgramActions(GripperContribution contribution) {
        super(contribution);
    }

    public void setContributionProvider(ContributionProvider<ProxyProgramNodeContribution> contributionProvider) {
        this.contributionProvider = contributionProvider;
    }

    @Override
    public void onGripButton() {
        if (this.checkRobotState()) {
            this.onQuickActionButton(Operation.GRIP);
        }
    }

    @Override
    public void onReleaseButton() {
        if (this.checkRobotState()) {
            this.onQuickActionButton(Operation.RELEASE);
        }
    }

    private void onQuickActionButton(Operation operation) {
        ProxyProgramNodeContribution contribution = (ProxyProgramNodeContribution)this.contributionProvider.get();
        ActionParameters params = contribution.createDefaultScripGenerationParams(operation);
        this.runAction(operation, params);
    }

    private void runAction(final Operation operation, final ActionParameters params) {
        Thread scriptThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ProgramActions.this.sendStopProgramToController();
                ScriptWriter scriptWriter = ProgramActions.this.generateScriptCode(params, operation);
                String script = scriptWriter.generateScript();
                ProgramActions.this.sendScriptToController(script);
            }
        });
        scriptThread.start();
    }

    @Override
    public void onGripperSelected(SelectableGripper gripper) {
        if (this.contributionProvider == null) {
            return;
        }
        ProxyProgramNodeContribution contribution = (ProxyProgramNodeContribution)this.contributionProvider.get();
        if (contribution == null) {
            return;
        }
        contribution.setSelectableGripper(gripper);
        contribution.initializeView();
    }

    public void testParameters(final Operation operation) {
        ProxyProgramNodeContribution contribution = (ProxyProgramNodeContribution)this.contributionProvider.get();
        final ActionParameters params = contribution.createTestScriptGenerationParams(operation);
        Thread scriptThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ProgramActions.this.sendStopProgramToController();
                ScriptWriter scriptWriter = ProgramActions.this.generateScriptCode(params, operation);
                com.ur.polyscope.scriptwriter.ScriptWriter writer = new com.ur.polyscope.scriptwriter.ScriptWriter();
                ((ProxyProgramNodeContribution)ProgramActions.this.contributionProvider.get()).writePayloadScript(writer);
                scriptWriter.appendLine(writer.generateScript());
                String script = scriptWriter.generateScript();
                ProgramActions.this.sendScriptToController(script);
            }
        });
        scriptThread.start();
    }

    @Override
    public AdjustParameterValue<Pressure> getVacuumParamSetter() {
        return new AdjustParameterValue<Pressure>(){

            @Override
            public void setValue(Pressure value) {
                ((ProxyProgramNodeContribution)ProgramActions.this.contributionProvider.get()).setVacuum(value);
            }
        };
    }

    @Override
    public AdjustParameterValue<Force> getForceParamSetter() {
        return new AdjustParameterValue<Force>(){

            @Override
            public void setValue(Force value) {
                ((ProxyProgramNodeContribution)ProgramActions.this.contributionProvider.get()).setForce(value);
            }
        };
    }

    @Override
    public AdjustParameterValue<Length> getWidthParamSetter() {
        return new AdjustParameterValue<Length>(){

            @Override
            public void setValue(Length value) {
                ((ProxyProgramNodeContribution)ProgramActions.this.contributionProvider.get()).setWidth(value);
            }
        };
    }

    @Override
    public AdjustParameterValue<Speed> getSpeedParamSetter() {
        return new AdjustParameterValue<Speed>(){

            @Override
            public void setValue(Speed value) {
                ((ProxyProgramNodeContribution)ProgramActions.this.contributionProvider.get()).setSpeed(value);
            }
        };
    }
}

