/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.program;

import com.ur.polyscope.gripper.internal.gripper.GripperContext;
import com.ur.polyscope.gripper.internal.gripper.PropertyChanger;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.SelectableGripper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;

public class ProgramGripperComboBoxModel
extends DefaultComboBoxModel
implements PropertyChangeListener {
    private GripperContext gripperContext;
    private String selectGripperText;

    public ProgramGripperComboBoxModel(GripperContext gripperContext, String selectGripperText) {
        this.selectGripperText = selectGripperText;
        this.gripperContext = gripperContext;
        this.addAllElements(this.selectGripperText);
        this.addListeners();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.reloadElements(this.getSelectedItem());
    }

    public void reloadElements(Object selectedItem) {
        if (!this.gripperContext.isMultiGripper()) {
            return;
        }
        this.removeAllElements();
        this.addAllElements(this.selectGripperText);
        this.setSelectedItem(selectedItem);
        this.addListeners();
    }

    private void addListeners() {
        this.removeListeners();
        for (SelectableGripper gripper : this.gripperContext.getGrippers()) {
            if (!(gripper instanceof PropertyChanger)) continue;
            ((PropertyChanger)gripper).addPropertyChangeListener(this);
        }
    }

    private void removeListeners() {
        for (SelectableGripper gripper : this.gripperContext.getGrippers()) {
            if (!(gripper instanceof PropertyChanger)) continue;
            ((PropertyChanger)gripper).removePropertyChangeListener(this);
        }
    }

    private void addAllElements(String selectGripperText) {
        this.addElement(selectGripperText);
        for (SelectableGripper gripper : this.gripperContext.getGrippersEnabled()) {
            this.addElement(gripper);
        }
    }
}

