/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.program;

import com.ur.polyscope.gripper.internal.gripper.GripperContext;
import com.ur.polyscope.gripper.internal.gripper.IdentifiableGripper;
import com.ur.polyscope.gripper.internal.gripper.params.GripperParam;
import com.ur.polyscope.gripper.internal.gripper.program.GripperDataModel;
import com.ur.polyscope.gripper.internal.gripper.program.ProgramGripperParam$UnresolvedGripper$AjcClosure1;
import com.ur.polyscope.gripper.internal.gripper.program.ProgramGripperParam$UnresolvedGripper$AjcClosure3;
import com.ur.polyscope.gripper.internal.gripper.program.ProgramGripperParam$UnresolvedGripper$AjcClosure5;
import com.ur.polyscope.gripper.internal.gripper.util.Enableable;
import com.ur.polyscope.gripper.internal.gripper.util.Resolvable;
import com.ur.polyscope.valueobjects.aspects.UncaughtExceptionAspect;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.SelectableGripper;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class ProgramGripperParam
implements GripperParam {
    private final GripperDataModel gripperDataModel;
    private final GripperContext gripperContext;

    public ProgramGripperParam(GripperDataModel gripperDataModel, GripperContext gripperContext) {
        this.gripperDataModel = gripperDataModel;
        this.gripperContext = gripperContext;
    }

    @Override
    public SelectableGripper getValue() {
        String id = this.gripperDataModel.getGripperId();
        SelectableGripper gripper = this.gripperContext.getGripperById(id);
        if (this.isNoGripperSelected(gripper, id)) {
            return null;
        }
        String name = this.gripperDataModel.getGripperName();
        if (this.isGripperNotAvailable(gripper)) {
            gripper = new UnresolvedGripper(id, name);
        }
        return gripper;
    }

    @Override
    public void setValue(SelectableGripper value) {
        this.gripperDataModel.setSelectableGripper(value);
    }

    @Override
    public boolean isDefined() {
        if (!this.gripperContext.isMultiGripper()) {
            return true;
        }
        SelectableGripper gripper = this.getValue();
        if (!(gripper instanceof Resolvable)) {
            return false;
        }
        return ((Resolvable)gripper).isResolvable();
    }

    private boolean isGripperNotAvailable(SelectableGripper gripper) {
        return gripper == null;
    }

    private boolean isNoGripperSelected(SelectableGripper gripper, String id) {
        return gripper == null && id == null;
    }

    private static class UnresolvedGripper
    implements SelectableGripper,
    IdentifiableGripper,
    Resolvable,
    Enableable {
        private String name;
        private String id;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        public UnresolvedGripper(String name, String id) {
            this.name = name;
            this.id = id;
        }

        public String getId() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            Object[] objectArray = new Object[]{this, joinPoint};
            ProgramGripperParam$UnresolvedGripper$AjcClosure1 programGripperParam$UnresolvedGripper$AjcClosure1 = new ProgramGripperParam$UnresolvedGripper$AjcClosure1(objectArray);
            return (String)UncaughtExceptionAspect.aspectOf().aroundMethod(programGripperParam$UnresolvedGripper$AjcClosure1.linkClosureAndJoinPoint(69648));
        }

        @Override
        public String getUniqueId() {
            return this.getId();
        }

        public String getDisplayName() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            Object[] objectArray = new Object[]{this, joinPoint};
            ProgramGripperParam$UnresolvedGripper$AjcClosure3 programGripperParam$UnresolvedGripper$AjcClosure3 = new ProgramGripperParam$UnresolvedGripper$AjcClosure3(objectArray);
            return (String)UncaughtExceptionAspect.aspectOf().aroundMethod(programGripperParam$UnresolvedGripper$AjcClosure3.linkClosureAndJoinPoint(69648));
        }

        @Override
        public void setEnabled(boolean enabled) {
        }

        @Override
        public boolean isEnabled() {
            return this.id != null && this.name != null;
        }

        @Override
        public boolean isResolvable() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
            Object[] objectArray = new Object[]{this, joinPoint};
            ProgramGripperParam$UnresolvedGripper$AjcClosure5 programGripperParam$UnresolvedGripper$AjcClosure5 = new ProgramGripperParam$UnresolvedGripper$AjcClosure5(objectArray);
            return Conversions.booleanValue((Object)UncaughtExceptionAspect.aspectOf().aroundMethod(programGripperParam$UnresolvedGripper$AjcClosure5.linkClosureAndJoinPoint(69648)));
        }

        public String toString() {
            return this.name;
        }

        static {
            UnresolvedGripper.ajc$preClinit();
        }

        static final /* synthetic */ String getId_aroundBody0(UnresolvedGripper ajc$this, JoinPoint joinPoint) {
            return ajc$this.id;
        }

        static final /* synthetic */ String getDisplayName_aroundBody2(UnresolvedGripper ajc$this, JoinPoint joinPoint) {
            return ajc$this.name;
        }

        static final /* synthetic */ boolean isResolvable_aroundBody4(UnresolvedGripper ajc$this, JoinPoint joinPoint) {
            return false;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("ProgramGripperParam.java", UnresolvedGripper.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getId", "com.ur.polyscope.gripper.internal.gripper.program.ProgramGripperParam$UnresolvedGripper", "", "", "", "java.lang.String"), 75);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDisplayName", "com.ur.polyscope.gripper.internal.gripper.program.ProgramGripperParam$UnresolvedGripper", "", "", "", "java.lang.String"), 85);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isResolvable", "com.ur.polyscope.gripper.internal.gripper.program.ProgramGripperParam$UnresolvedGripper", "", "", "", "boolean"), 100);
        }
    }
}

