/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.program;

import com.ur.polyscope.gripper.internal.gripper.GripperContext;
import com.ur.polyscope.gripper.internal.gripper.common.widgets.NoGrippersMessagePanel;
import com.ur.polyscope.gripper.internal.gripper.operations.SelectOperationsPanel;
import com.ur.polyscope.gripper.internal.gripper.params.GripperParam;
import com.ur.polyscope.gripper.internal.gripper.params.Operation;
import com.ur.polyscope.gripper.internal.gripper.params.ParamsDefinition;
import com.ur.polyscope.gripper.internal.gripper.params.view.ParametersDefinedPanel;
import com.ur.polyscope.gripper.internal.gripper.program.GripperDataModel;
import com.ur.polyscope.gripper.internal.gripper.program.MultiGripperSelectionPanel;
import com.ur.polyscope.gripper.internal.gripper.program.PayloadWarningPanel;
import com.ur.polyscope.gripper.internal.gripper.program.ProgramActions;
import com.ur.polyscope.gripper.internal.gripper.program.ProgramNodeView$AjcClosure1;
import com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution;
import com.ur.polyscope.gripper.internal.gripper.program.TestParametersPanel;
import com.ur.polyscope.gripper.internal.gripper.program.actions.GripperProgramNode;
import com.ur.polyscope.gripper.internal.gripper.program.ui.ActiveOperation;
import com.ur.polyscope.gripper.internal.gripper.program.ui.FooterPanel;
import com.ur.polyscope.gripper.internal.resources.ImageResource;
import com.ur.polyscope.gripper.resource.internal.TextResource;
import com.ur.polyscope.installation.urcap.proxy.Defined;
import com.ur.polyscope.urcaps.URCapErrorPanel;
import com.ur.polyscope.urcaps.contributions.SwingProgramNodeViewHasLogo;
import com.ur.polyscope.valueobjects.aspects.UncaughtExceptionAspect;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.urcap.api.contribution.ContributionProvider;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ProgramNodeView
implements SwingProgramNodeViewHasLogo<ProxyProgramNodeContribution> {
    public static final int LOGO_WIDTH = 200;
    public static final int LOGO_HEIGHT = 60;
    public static final String NO_GRIPPERS = "NO-GRIPPERS";
    public static final String GRIPPERS = "GRIPPERS";
    private Icon imageIcon;
    private String gripperTitle;
    private final ViewContext viewContext;
    private GripperContext gripperContext;
    private ProgramActions actions;
    private Defined backendDefined;
    private final MultiGripperSelectionPanel multiGripperSelectionPanel;
    private final ParametersDefinedPanel paramsPanel;
    private final SelectOperationsPanel operationsPanel;
    private final TestParametersPanel testParametersPanel;
    private final PayloadWarningPanel payloadWarningPanel;
    private final FooterPanel feedbackPanel;
    private JPanel rootPanel;
    private JPanel mainPanel;
    private URCapErrorPanel errorPanel;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Inject
    public ProgramNodeView(MultiGripperSelectionPanel multiGripperSelectionPanel, ParametersDefinedPanel paramsPanel, SelectOperationsPanel operationsPanel, TestParametersPanel testParametersPanel, PayloadWarningPanel payloadWarningPanel, FooterPanel feedbackPanel, ViewContext viewContext) {
        this.multiGripperSelectionPanel = multiGripperSelectionPanel;
        this.paramsPanel = paramsPanel;
        this.operationsPanel = operationsPanel;
        this.testParametersPanel = testParametersPanel;
        this.payloadWarningPanel = payloadWarningPanel;
        this.feedbackPanel = feedbackPanel;
        this.viewContext = viewContext;
    }

    public void init(String title, Icon scaledLogo, Defined backendDefined, GripperContext gripperContext, ProgramActions actions) {
        this.gripperTitle = title;
        this.imageIcon = scaledLogo;
        this.backendDefined = backendDefined;
        this.gripperContext = gripperContext;
        this.actions = actions;
    }

    public void buildUI(JPanel panel, ContributionProvider<ProxyProgramNodeContribution> contributionProvider) {
        JPanel jPanel = panel;
        ContributionProvider<ProxyProgramNodeContribution> contributionProvider2 = contributionProvider;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)jPanel, contributionProvider2);
        Object[] objectArray = new Object[]{this, jPanel, contributionProvider2, joinPoint};
        ProgramNodeView$AjcClosure1 programNodeView$AjcClosure1 = new ProgramNodeView$AjcClosure1(objectArray);
        UncaughtExceptionAspect.aspectOf().aroundMethod(programNodeView$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public void initialize(GripperDataModel dataModel, ParamsDefinition paramsDefinition, GripperParam gripperParam) {
        if (this.gripperContext.hasInitializationException()) {
            this.initializeErrorPanel();
        } else {
            this.initializeMainPanel(dataModel, paramsDefinition, gripperParam);
        }
    }

    private void initializeErrorPanel() {
        this.rootPanel.removeAll();
        this.rootPanel.add((Component)this.errorPanel);
        this.errorPanel.setStackTrace(this.gripperContext.getInitializationExceptionStackTrace());
        this.errorPanel.setMetadataFromClass(this.gripperContext.getContributionClass());
    }

    private void initializeMainPanel(GripperDataModel dataModel, ParamsDefinition paramsDefinition, GripperParam gripperParam) {
        this.rootPanel.removeAll();
        this.rootPanel.add(this.mainPanel);
        Operation operation = dataModel.getOperation();
        boolean hasGripper = !this.gripperContext.isMultiGripper() || !this.gripperContext.getGrippersEnabled().isEmpty();
        CardLayout cardLayout = (CardLayout)this.mainPanel.getLayout();
        cardLayout.show(this.mainPanel, hasGripper ? GRIPPERS : NO_GRIPPERS);
        this.multiGripperSelectionPanel.initialize(gripperParam);
        this.operationsPanel.initialize(operation);
        this.paramsPanel.initialize(operation, dataModel, paramsDefinition);
        this.testParametersPanel.initialize(operation, gripperParam);
        this.payloadWarningPanel.initialize(operation);
        this.feedbackPanel.initialize(operation);
    }

    public Icon getLogo() {
        return this.imageIcon;
    }

    public Icon getIcon() {
        return ImageResource.gripperNodeDefined();
    }

    public Icon getUndefinedIcon() {
        return ImageResource.gripperNodeUndefined();
    }

    public void close() {
        this.paramsPanel.close();
    }

    static {
        ProgramNodeView.ajc$preClinit();
    }

    static final /* synthetic */ void buildUI_aroundBody0(ProgramNodeView ajc$this, JPanel panel, final ContributionProvider contributionProvider, JoinPoint joinPoint) {
        panel.setLayout(new BorderLayout());
        Dimension panelSize = panel.getSize();
        ajc$this.rootPanel = new JPanel();
        ajc$this.rootPanel.setBorder(BorderFactory.createEmptyBorder());
        BorderLayout layout = new BorderLayout();
        ajc$this.rootPanel.setLayout(layout);
        ajc$this.rootPanel.setMinimumSize(panelSize);
        ajc$this.rootPanel.setMaximumSize(panelSize);
        ajc$this.rootPanel.setPreferredSize(panelSize);
        ajc$this.rootPanel.setSize(panelSize);
        panel.add(ajc$this.rootPanel);
        ajc$this.errorPanel = GripperContext.createErrorPanel();
        ajc$this.errorPanel.setMinimumSize(panelSize);
        ajc$this.errorPanel.setMaximumSize(panelSize);
        ajc$this.errorPanel.setPreferredSize(panelSize);
        ajc$this.errorPanel.setSize(panelSize);
        ajc$this.mainPanel = new JPanel();
        ajc$this.mainPanel.setBorder(BorderFactory.createEmptyBorder());
        ajc$this.mainPanel.setMinimumSize(panelSize);
        ajc$this.mainPanel.setMaximumSize(panelSize);
        ajc$this.mainPanel.setPreferredSize(panelSize);
        ajc$this.mainPanel.setSize(panelSize);
        ajc$this.actions.setContributionProvider((ContributionProvider<ProxyProgramNodeContribution>)contributionProvider);
        Provider<GripperProgramNode> provider = new Provider<GripperProgramNode>(){

            public GripperProgramNode get() {
                return (GripperProgramNode)contributionProvider.get();
            }
        };
        ajc$this.mainPanel.setLayout(new CardLayout());
        ajc$this.mainPanel.add((Component)new NoGrippersMessagePanel((TextResource)ajc$this.viewContext.getTextResource(TextResource.class), ajc$this.gripperTitle), NO_GRIPPERS);
        FormBuilder formBuilder = ajc$this.viewContext.createFormBuilder();
        ajc$this.multiGripperSelectionPanel.buildUI(ajc$this.actions, ajc$this.gripperContext, formBuilder);
        ajc$this.operationsPanel.buildUI(provider, formBuilder);
        ajc$this.paramsPanel.buildUI(provider, ajc$this.actions, ajc$this.gripperContext, formBuilder);
        ajc$this.testParametersPanel.buildUI(provider, ajc$this.actions, ajc$this.gripperContext, ajc$this.operationsPanel, formBuilder);
        ajc$this.payloadWarningPanel.buildUI(provider, formBuilder);
        ajc$this.feedbackPanel.buildUI(provider, ajc$this.gripperTitle, ajc$this.backendDefined, formBuilder);
        ajc$this.mainPanel.add((Component)formBuilder.getRow(), GRIPPERS);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ProgramNodeView.java", ProgramNodeView.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "buildUI", "com.ur.polyscope.gripper.internal.gripper.program.ProgramNodeView", "javax.swing.JPanel:com.ur.urcap.api.contribution.ContributionProvider", "panel:contributionProvider", "", "void"), 85);
    }

    public static final class TestParametersAction
    extends AbstractAction {
        private static final String TEST_PARAMETERS = "testParameters.ProgramNodeView";
        private final ProgramActions programActions;
        private final ActiveOperation selection;

        public TestParametersAction(TextResource textResource, ActiveOperation selection, ProgramActions programActions) {
            this.selection = selection;
            this.programActions = programActions;
            this.putValue("Name", textResource.test());
            this.putValue("InternalName", TEST_PARAMETERS);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.programActions.checkRobotState()) {
                if (this.selection.isSelected(Operation.GRIP)) {
                    this.programActions.testParameters(Operation.GRIP);
                } else if (this.selection.isSelected(Operation.RELEASE)) {
                    this.programActions.testParameters(Operation.RELEASE);
                }
            }
        }
    }
}

