/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.program;

import com.ur.lang.StringUtils;
import com.ur.polyscope.gripper.internal.gripper.AbstractProxiedService;
import com.ur.polyscope.gripper.internal.gripper.GripperContext;
import com.ur.polyscope.gripper.internal.gripper.SelectableGripperImpl;
import com.ur.polyscope.gripper.internal.gripper.operations.SetOperationAction;
import com.ur.polyscope.gripper.internal.gripper.params.ActionParameters;
import com.ur.polyscope.gripper.internal.gripper.params.GripperParam;
import com.ur.polyscope.gripper.internal.gripper.params.Operation;
import com.ur.polyscope.gripper.internal.gripper.params.ParamsDefinition;
import com.ur.polyscope.gripper.internal.gripper.params.ScriptGenerationParamsBuilder;
import com.ur.polyscope.gripper.internal.gripper.program.GripperDataModel;
import com.ur.polyscope.gripper.internal.gripper.program.GripperDataModelImpl;
import com.ur.polyscope.gripper.internal.gripper.program.GripperNodeConfigExtractor;
import com.ur.polyscope.gripper.internal.gripper.program.GripperSelectionProvider;
import com.ur.polyscope.gripper.internal.gripper.program.ProgramGripperParam;
import com.ur.polyscope.gripper.internal.gripper.program.ProgramNodeView;
import com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution$1$AjcClosure1;
import com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution$2$AjcClosure1;
import com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution$3$AjcClosure1;
import com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution$4$AjcClosure1;
import com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution$5$AjcClosure1;
import com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution$6$AjcClosure1;
import com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution$AjcClosure1;
import com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution$AjcClosure11;
import com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution$AjcClosure13;
import com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution$AjcClosure3;
import com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution$AjcClosure5;
import com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution$AjcClosure7;
import com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution$AjcClosure9;
import com.ur.polyscope.gripper.internal.gripper.program.actions.GripperProgramNode;
import com.ur.polyscope.gripper.internal.gripper.program.actions.KeepNodeSelectionAction;
import com.ur.polyscope.gripper.internal.gripper.program.actions.SetGripperConfigAction;
import com.ur.polyscope.gripper.internal.gripper.program.actions.TreeModificationVeto;
import com.ur.polyscope.gripper.internal.gripper.program.outcome.OutcomeParent;
import com.ur.polyscope.gripper.internal.gripper.program.outcome.StepCounter;
import com.ur.polyscope.gripper.internal.gripper.program.outcome.rules.OutcomeNodesCannotBeRemoved;
import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadConstants;
import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadNotSelected;
import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadWithMassOnly;
import com.ur.polyscope.gripper.resource.internal.TextResource;
import com.ur.polyscope.installation.urcap.proxy.Defined;
import com.ur.polyscope.payload.common.PayloadScriptGenerator;
import com.ur.polyscope.persistence.versioning.Version;
import com.ur.polyscope.persistence.versioning.Versioned;
import com.ur.polyscope.program.PlaceholderOperationService;
import com.ur.polyscope.program.nodes.ProgramNodeType;
import com.ur.polyscope.urcaps.exception.ProxiedException;
import com.ur.polyscope.urcaps.extensions.programnodecontribution.IconContribution;
import com.ur.polyscope.urcaps.util.OptionalImpl;
import com.ur.polyscope.valueobjects.Force;
import com.ur.polyscope.valueobjects.Length;
import com.ur.polyscope.valueobjects.Pressure;
import com.ur.polyscope.valueobjects.Speed;
import com.ur.polyscope.valueobjects.aspects.UncaughtExceptionAspect;
import com.ur.urcap.api.contribution.ProgramNodeContribution;
import com.ur.urcap.api.contribution.driver.gripper.GripActionParameters;
import com.ur.urcap.api.contribution.driver.gripper.GripperContribution;
import com.ur.urcap.api.contribution.driver.gripper.ReleaseActionParameters;
import com.ur.urcap.api.contribution.driver.gripper.conformant.GripperConfigurable;
import com.ur.urcap.api.contribution.driver.gripper.conformant.GripperNodeConfigBuilders;
import com.ur.urcap.api.contribution.program.CreationContext;
import com.ur.urcap.api.contribution.program.ProgramAPIProvider;
import com.ur.urcap.api.domain.data.DataModel;
import com.ur.urcap.api.domain.device.gripper.GripperDevice;
import com.ur.urcap.api.domain.payload.Payload;
import com.ur.urcap.api.domain.program.ProgramModel;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.CustomPayloadParameters;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.GripActionConfig;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.GripperNodeConfig;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.PayloadSelection;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.PayloadSetting;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.ReleaseActionConfig;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.SelectableGripper;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.script.ScriptWriter;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import com.ur.urcap.api.domain.undoredo.UndoableChanges;
import com.ur.urcap.api.domain.value.simple.Mass;
import com.ur.urcap.api.util.Optional;
import java.util.Locale;
import javax.inject.Inject;
import javax.swing.Icon;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class ProxyProgramNodeContribution
extends AbstractProxiedService
implements ProgramNodeContribution,
IconContribution,
ProgramNodeType,
GripperConfigurable,
GripperProgramNode,
OutcomeParent,
Versioned,
GripperSelectionProvider {
    public static final Version LATEST_VERSION;
    private static PlaceholderOperationService placeholderOperationService;
    private static OutcomeNodesCannotBeRemoved outcomeNodesCannotBeRemovedRule;
    private static TextResource textResource;
    private final GripperContribution service;
    private final Defined backendDefined;
    private final ProgramNodeView view;
    private final GripperDataModel gripperDataModel;
    private final GripperParam gripperParam;
    private final UndoRedoManager undoRedoManager;
    private final ParamsDefinition paramDef;
    private final ProgramModel programModel;
    private final GripperContext gripperContext;
    private Version version = LATEST_VERSION;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    static {
        ProxyProgramNodeContribution.ajc$preClinit();
        LATEST_VERSION = new Version(2, 0);
    }

    public ProxyProgramNodeContribution(GripperContribution service, Defined backendDefined, ProgramAPIProvider apiProvider, ProgramNodeView view, DataModel model, GripperContext gripperContext, CreationContext context) {
        super(service.getClass());
        this.service = service;
        this.backendDefined = backendDefined;
        this.view = view;
        this.undoRedoManager = apiProvider.getProgramAPI().getUndoRedoManager();
        this.gripperDataModel = new GripperDataModelImpl(model, gripperContext, context.getNodeCreationType());
        this.gripperContext = gripperContext;
        this.paramDef = gripperContext.getParamsDefinition();
        this.programModel = apiProvider.getProgramAPI().getProgramModel();
        this.gripperParam = new ProgramGripperParam(this.gripperDataModel, gripperContext);
        this.programModel.getRootTreeNode((ProgramNodeContribution)this).setChildSequenceLocked(true);
        if (context.getNodeCreationType().equals((Object)CreationContext.NodeCreationType.NEW) && gripperContext.isOnlyOneGripperAvailable()) {
            SelectableGripper gripper = gripperContext.getGrippersEnabled().iterator().next();
            this.setSelectableGripper(gripper);
        }
    }

    @Inject
    public static void setPlaceholderOperationService(PlaceholderOperationService placeholderOperationService) {
        ProxyProgramNodeContribution.placeholderOperationService = placeholderOperationService;
    }

    @Inject
    public static void setOutcomeNodesCannotBeRemovedRule(OutcomeNodesCannotBeRemoved rule) {
        outcomeNodesCannotBeRemovedRule = rule;
    }

    @Inject
    public static void setTextResource(TextResource resource) {
        textResource = resource;
    }

    public void openView() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        ProxyProgramNodeContribution$AjcClosure1 proxyProgramNodeContribution$AjcClosure1 = new ProxyProgramNodeContribution$AjcClosure1(objectArray);
        UncaughtExceptionAspect.aspectOf().aroundMethod(proxyProgramNodeContribution$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Override
    public void initializeView() {
        SelectableGripper selectedGripper = this.getSelectedGripper();
        ParamsDefinition paramsDefinition = selectedGripper == null ? this.gripperContext.getParamsDefinition() : this.gripperContext.getParamsDefinition(selectedGripper);
        this.view.initialize(this.gripperDataModel, paramsDefinition, this.gripperParam);
    }

    @Override
    public SelectableGripper getSelectedGripper() {
        return this.gripperContext.getGripperById(this.gripperDataModel.getGripperId());
    }

    public void closeView() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        ProxyProgramNodeContribution$AjcClosure3 proxyProgramNodeContribution$AjcClosure3 = new ProxyProgramNodeContribution$AjcClosure3(objectArray);
        UncaughtExceptionAspect.aspectOf().aroundMethod(proxyProgramNodeContribution$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    public String getTitle() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        ProxyProgramNodeContribution$AjcClosure5 proxyProgramNodeContribution$AjcClosure5 = new ProxyProgramNodeContribution$AjcClosure5(objectArray);
        return (String)UncaughtExceptionAspect.aspectOf().aroundMethod(proxyProgramNodeContribution$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    private String getGripperTitle() {
        SelectableGripper selectedGripper = this.getSelectedGripper();
        return selectedGripper != null && this.gripperCount() >= 2 ? selectedGripper.getDisplayName() : this.doGetTitle();
    }

    private String doGetTitle() {
        try {
            return this.service.getTitle(Locale.getDefault());
        }
        catch (RuntimeException e) {
            throw new ProxiedException(e, this.service.getClass(), "com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution", "doGetTitle");
        }
    }

    private int gripperCount() {
        return this.gripperContext.getGrippersEnabled().size();
    }

    private String getOperationName() {
        String operationName;
        switch (this.getOperation()) {
            case GRIP: {
                operationName = ": " + textResource.grip();
                break;
            }
            case RELEASE: {
                operationName = ": " + textResource.release();
                break;
            }
            default: {
                operationName = "";
            }
        }
        return operationName;
    }

    private String getPayloadString() {
        if (this.getOperation() == Operation.UNDEFINED) {
            return "";
        }
        if (this.isUsePayload()) {
            Payload payload = this.getPayload();
            if (!payload.isResolvable()) {
                return "";
            }
            Mass mass = payload.getMass();
            String payloadString = PayloadConstants.getProgramTreeValue(mass);
            if (!payloadString.isEmpty()) {
                String payloadName = "";
                if (!(payload instanceof PayloadWithMassOnly)) {
                    payloadName = payload.getDisplayName();
                }
                if (payloadName.isEmpty()) {
                    return ", " + payloadString;
                }
                return ", " + payloadName + " (" + payloadString + ")";
            }
        }
        return "";
    }

    @Override
    public boolean isPayloadValid() {
        return this.gripperDataModel.isPayloadValid();
    }

    public boolean isDefined() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        ProxyProgramNodeContribution$AjcClosure7 proxyProgramNodeContribution$AjcClosure7 = new ProxyProgramNodeContribution$AjcClosure7(objectArray);
        return Conversions.booleanValue((Object)UncaughtExceptionAspect.aspectOf().aroundMethod(proxyProgramNodeContribution$AjcClosure7.linkClosureAndJoinPoint(69648)));
    }

    public void generateScript(ScriptWriter writer) {
        ScriptWriter scriptWriter = writer;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)scriptWriter);
        Object[] objectArray = new Object[]{this, scriptWriter, joinPoint};
        ProxyProgramNodeContribution$AjcClosure9 proxyProgramNodeContribution$AjcClosure9 = new ProxyProgramNodeContribution$AjcClosure9(objectArray);
        UncaughtExceptionAspect.aspectOf().aroundMethod(proxyProgramNodeContribution$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    private void getGripActionScript(ScriptWriter writer, ActionParameters params) {
        try {
            this.service.generateGripActionScript(writer, (GripActionParameters)params);
        }
        catch (RuntimeException e) {
            throw new ProxiedException(e, this.service.getClass(), "com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution", "getGripActionScript");
        }
    }

    private void getReleaseActionScript(ScriptWriter writer, ActionParameters params) {
        try {
            this.service.generateReleaseActionScript(writer, (ReleaseActionParameters)params);
        }
        catch (RuntimeException e) {
            throw new ProxiedException(e, this.service.getClass(), "com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution", "getReleaseActionScript");
        }
    }

    @Override
    public void generateOnSuccessScriptCode(com.ur.polyscope.scriptwriter.ScriptWriter writer) {
        this.writePayloadScript(writer);
    }

    public void writePayloadScript(com.ur.polyscope.scriptwriter.ScriptWriter writer) {
        Payload payload;
        if (this.isUsePayload() && (payload = this.getPayload()) instanceof PayloadScriptGenerator) {
            ((PayloadScriptGenerator)payload).generatePayloadScript(writer);
        }
    }

    @Override
    public String getTimeoutVariable() {
        return String.valueOf(this.getOperation().toString().toLowerCase()) + "_timeout_step_count" + this.gripperContext.getContributionId() + this.suffix(this.getSelectedGripperUniqueId());
    }

    private String suffix(String individualMultiGripperUniqueId) {
        return StringUtils.isNullOrEmpty((String)individualMultiGripperUniqueId) ? "" : "_" + individualMultiGripperUniqueId;
    }

    @Override
    public String getSuccessCondition() {
        return this.getOperation().getFeedbackFunction(this.gripperContext, this.getSelectedGripperUniqueId());
    }

    public String getSelectedGripperUniqueId() {
        SelectableGripper gripperById = this.getSelectedGripper();
        return gripperById instanceof SelectableGripperImpl ? ((SelectableGripperImpl)gripperById).getUniqueId() : "";
    }

    @Override
    public Operation getOperation() {
        return this.gripperDataModel.getOperation();
    }

    @Override
    public void setPayload(boolean usePayload, Payload payload) {
        this.gripperDataModel.setUsePayload(usePayload);
        this.gripperDataModel.setPayload(payload);
    }

    @Override
    public boolean isUsePayload() {
        return this.gripperDataModel.isUsePayload();
    }

    @Override
    public Payload getPayload() {
        return this.gripperDataModel.getPayload();
    }

    @Override
    public void setOperation(Operation operation) {
        this.gripperDataModel.setOperation(operation);
    }

    @Override
    public void setSelectableGripper(final SelectableGripper gripper) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){
            private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            public void executeChanges() {
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                Object[] objectArray = new Object[]{this, joinPoint};
                ProxyProgramNodeContribution$1$AjcClosure1 proxyProgramNodeContribution$1$AjcClosure1 = new ProxyProgramNodeContribution$1$AjcClosure1(objectArray);
                UncaughtExceptionAspect.aspectOf().aroundMethod(proxyProgramNodeContribution$1$AjcClosure1.linkClosureAndJoinPoint(69648));
            }

            static {
                1.ajc$preClinit();
            }

            static final /* synthetic */ void executeChanges_aroundBody0(1 ajc$this, JoinPoint joinPoint) {
                ajc$this.ProxyProgramNodeContribution.this.gripperDataModel.setSelectableGripper(ajc$this.gripper);
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("ProxyProgramNodeContribution.java", 1.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeChanges", "com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution$1", "", "", "", "void"), 369);
            }
        });
    }

    public Length getWidth() {
        return this.gripperDataModel.getWidth();
    }

    public void setWidth(final Length value) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){
            private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            public void executeChanges() {
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                Object[] objectArray = new Object[]{this, joinPoint};
                ProxyProgramNodeContribution$2$AjcClosure1 proxyProgramNodeContribution$2$AjcClosure1 = new ProxyProgramNodeContribution$2$AjcClosure1(objectArray);
                UncaughtExceptionAspect.aspectOf().aroundMethod(proxyProgramNodeContribution$2$AjcClosure1.linkClosureAndJoinPoint(69648));
            }

            static {
                2.ajc$preClinit();
            }

            static final /* synthetic */ void executeChanges_aroundBody0(2 ajc$this, JoinPoint joinPoint) {
                ajc$this.ProxyProgramNodeContribution.this.gripperDataModel.setWidth(ajc$this.value);
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("ProxyProgramNodeContribution.java", 2.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeChanges", "com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution$2", "", "", "", "void"), 382);
            }
        });
    }

    public Pressure getVacuum() {
        return this.gripperDataModel.getVacuum();
    }

    public void setVacuum(final Pressure value) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){
            private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            public void executeChanges() {
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                Object[] objectArray = new Object[]{this, joinPoint};
                ProxyProgramNodeContribution$3$AjcClosure1 proxyProgramNodeContribution$3$AjcClosure1 = new ProxyProgramNodeContribution$3$AjcClosure1(objectArray);
                UncaughtExceptionAspect.aspectOf().aroundMethod(proxyProgramNodeContribution$3$AjcClosure1.linkClosureAndJoinPoint(69648));
            }

            static {
                3.ajc$preClinit();
            }

            static final /* synthetic */ void executeChanges_aroundBody0(3 ajc$this, JoinPoint joinPoint) {
                ajc$this.ProxyProgramNodeContribution.this.gripperDataModel.setVacuum(ajc$this.value);
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("ProxyProgramNodeContribution.java", 3.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeChanges", "com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution$3", "", "", "", "void"), 395);
            }
        });
    }

    public Force getForce() {
        return this.gripperDataModel.getForce();
    }

    public void setForce(final Force value) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){
            private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            public void executeChanges() {
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                Object[] objectArray = new Object[]{this, joinPoint};
                ProxyProgramNodeContribution$4$AjcClosure1 proxyProgramNodeContribution$4$AjcClosure1 = new ProxyProgramNodeContribution$4$AjcClosure1(objectArray);
                UncaughtExceptionAspect.aspectOf().aroundMethod(proxyProgramNodeContribution$4$AjcClosure1.linkClosureAndJoinPoint(69648));
            }

            static {
                4.ajc$preClinit();
            }

            static final /* synthetic */ void executeChanges_aroundBody0(4 ajc$this, JoinPoint joinPoint) {
                ajc$this.ProxyProgramNodeContribution.this.gripperDataModel.setForce(ajc$this.value);
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("ProxyProgramNodeContribution.java", 4.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeChanges", "com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution$4", "", "", "", "void"), 408);
            }
        });
    }

    public Speed getSpeed() {
        return this.gripperDataModel.getSpeed();
    }

    public void setSpeed(final Speed value) {
        this.undoRedoManager.recordChanges(new UndoableChanges(){
            private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            public void executeChanges() {
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                Object[] objectArray = new Object[]{this, joinPoint};
                ProxyProgramNodeContribution$5$AjcClosure1 proxyProgramNodeContribution$5$AjcClosure1 = new ProxyProgramNodeContribution$5$AjcClosure1(objectArray);
                UncaughtExceptionAspect.aspectOf().aroundMethod(proxyProgramNodeContribution$5$AjcClosure1.linkClosureAndJoinPoint(69648));
            }

            static {
                5.ajc$preClinit();
            }

            static final /* synthetic */ void executeChanges_aroundBody0(5 ajc$this, JoinPoint joinPoint) {
                ajc$this.ProxyProgramNodeContribution.this.gripperDataModel.setSpeed(ajc$this.value);
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("ProxyProgramNodeContribution.java", 5.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeChanges", "com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution$5", "", "", "", "void"), 421);
            }
        });
    }

    public ActionParameters createScripGenerationParams(Operation operation) {
        return new ScriptGenerationParamsBuilder().with(this.gripperDataModel, operation).with(this.gripperParam.getValue()).withGripDetectionEnabled(this.isFeedbackDetectionEnabled() && operation == Operation.GRIP).withGripDetectionSupported(this.isFeedbackDetectionSupported(Operation.GRIP)).withReleaseDetectionEnabled(this.isFeedbackDetectionEnabled() && operation == Operation.RELEASE).withReleaseDetectionSupported(this.isFeedbackDetectionSupported(Operation.RELEASE)).build();
    }

    public ActionParameters createTestScriptGenerationParams(Operation operation) {
        return new ScriptGenerationParamsBuilder().with(this.gripperDataModel, operation).with(this.gripperParam.getValue()).withGripDetectionEnabled(false).withGripDetectionSupported(this.isFeedbackDetectionSupported(Operation.GRIP)).withReleaseDetectionEnabled(false).withReleaseDetectionSupported(this.isFeedbackDetectionSupported(Operation.RELEASE)).build();
    }

    public ActionParameters createDefaultScripGenerationParams(Operation operation) {
        return new ScriptGenerationParamsBuilder().with(this.paramDef, operation).with(this.gripperParam.getValue()).withGripDetectionEnabled(false).withGripDetectionSupported(this.isFeedbackDetectionSupported(Operation.GRIP)).withReleaseDetectionEnabled(false).withReleaseDetectionSupported(this.isFeedbackDetectionSupported(Operation.RELEASE)).build();
    }

    public Icon getIcon(boolean isUndefined) {
        return isUndefined ? this.view.getUndefinedIcon() : this.view.getIcon();
    }

    public boolean isChildrenAllowed() {
        return this.isFeedbackDetectionEnabled();
    }

    public boolean isPlaceHolderRequired() {
        return false;
    }

    @Override
    public void setFeedbackDetectionEnabled(boolean enabled) {
        this.gripperDataModel.setFeedbackDetectionEnabled(enabled);
    }

    @Override
    public boolean isFeedbackDetectionEnabled() {
        Operation operation = this.getOperation();
        if (!this.isFeedbackDetectionSupported(operation)) {
            return false;
        }
        return this.gripperDataModel.isFeedbackDetectionEnabled();
    }

    @Override
    public boolean isFeedbackDetectionSupported(Operation operation) {
        return operation.isFeedbackDetectionSupported(this.gripperContext);
    }

    @Override
    public boolean isMultiGripper() {
        return this.gripperContext.isMultiGripper();
    }

    @Override
    public boolean isMultiGripperSelectionPossible() {
        return !this.gripperContext.getGrippersEnabled().isEmpty();
    }

    public void setConfig(GripperNodeConfig config) {
        GripperNodeConfig gripperNodeConfig = config;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)gripperNodeConfig);
        Object[] objectArray = new Object[]{this, gripperNodeConfig, joinPoint};
        ProxyProgramNodeContribution$AjcClosure11 proxyProgramNodeContribution$AjcClosure11 = new ProxyProgramNodeContribution$AjcClosure11(objectArray);
        UncaughtExceptionAspect.aspectOf().aroundMethod(proxyProgramNodeContribution$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    private void applyPayloadConfig(GripperNodeConfig config) {
        if (config.getConfigType() == GripperNodeConfig.ConfigType.UNDEFINED) {
            return;
        }
        Optional<PayloadSetting> payloadSettingOptional = this.getPayloadSetting(config);
        if (payloadSettingOptional.isPresent()) {
            PayloadSetting payloadSetting = (PayloadSetting)payloadSettingOptional.get();
            switch (payloadSetting.getSettingType()) {
                case UNDEFINED: {
                    this.setPayload(true, new PayloadNotSelected());
                    break;
                }
                case PAYLOAD_SELECTION: {
                    Payload payload = ((PayloadSelection)payloadSetting).getPayload();
                    this.setPayload(true, payload);
                    break;
                }
                case CUSTOM_PARAMETERS: {
                    this.setCustomPaylaod((CustomPayloadParameters)payloadSetting);
                    break;
                }
                default: {
                    this.setPayload(false, new PayloadNotSelected());
                    break;
                }
            }
        } else {
            this.setPayload(false, new PayloadNotSelected());
        }
    }

    private Optional<PayloadSetting> getPayloadSetting(GripperNodeConfig config) {
        GripperNodeConfig.ConfigType action = config.getConfigType();
        switch (action) {
            case GRIP_ACTION: {
                return ((GripActionConfig)config).getPayloadSetting();
            }
            case RELEASE_ACTION: {
                return ((ReleaseActionConfig)config).getPayloadSetting();
            }
        }
        return OptionalImpl.empty();
    }

    private void setCustomPaylaod(CustomPayloadParameters payloadSetting) {
        Optional mass = payloadSetting.getPayloadMass();
        if (mass.isPresent()) {
            this.setPayload(true, new PayloadWithMassOnly((Mass)mass.get()));
        } else {
            this.setPayload(true, new PayloadWithMassOnly());
        }
    }

    public GripperNodeConfig getConfig(GripperNodeConfigBuilders gripperNodeConfigBuilders) {
        GripperNodeConfigBuilders gripperNodeConfigBuilders2 = gripperNodeConfigBuilders;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)gripperNodeConfigBuilders2);
        Object[] objectArray = new Object[]{this, gripperNodeConfigBuilders2, joinPoint};
        ProxyProgramNodeContribution$AjcClosure13 proxyProgramNodeContribution$AjcClosure13 = new ProxyProgramNodeContribution$AjcClosure13(objectArray);
        return (GripperNodeConfig)UncaughtExceptionAspect.aspectOf().aroundMethod(proxyProgramNodeContribution$AjcClosure13.linkClosureAndJoinPoint(69648));
    }

    @Override
    public Optional<SelectableGripper> getGripperSelection() {
        String gripperId = this.gripperDataModel.getGripperId();
        if (gripperId == null) {
            return OptionalImpl.empty();
        }
        SelectableGripper gripper = this.getSelectedGripper();
        return OptionalImpl.of((Object)gripper);
    }

    @Override
    public UndoRedoManager getUndoRedoManager() {
        return this.undoRedoManager;
    }

    @Override
    public TreeNode getRootTreeNode() {
        return this.programModel.getRootTreeNode((ProgramNodeContribution)this);
    }

    @Override
    public TreeModificationVeto getTreeModificationVeto() {
        return outcomeNodesCannotBeRemovedRule;
    }

    @Override
    public PlaceholderOperationService getPlaceholderOperationService() {
        return placeholderOperationService;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        if (version == null || version.getMajor() < LATEST_VERSION.getMajor()) {
            this.gripperDataModel.convertDataModelIfRequired();
        }
        this.version = LATEST_VERSION;
    }

    @Override
    public GripperDevice getGripperDevice() {
        return this.gripperContext.getGripperDevice();
    }

    static final /* synthetic */ void openView_aroundBody0(ProxyProgramNodeContribution ajc$this, JoinPoint joinPoint) {
        ajc$this.initializeView();
    }

    static final /* synthetic */ void closeView_aroundBody2(ProxyProgramNodeContribution ajc$this, JoinPoint joinPoint) {
        ajc$this.view.close();
    }

    static final /* synthetic */ String getTitle_aroundBody4(ProxyProgramNodeContribution ajc$this, JoinPoint joinPoint) {
        return String.valueOf(ajc$this.getGripperTitle()) + ajc$this.getOperationName() + ajc$this.getPayloadString();
    }

    static final /* synthetic */ boolean isDefined_aroundBody6(ProxyProgramNodeContribution ajc$this, JoinPoint joinPoint) {
        if (!ajc$this.getOperation().isDefined()) {
            return false;
        }
        if (!ajc$this.gripperDataModel.isValid()) {
            return false;
        }
        if (!ajc$this.gripperParam.isDefined()) {
            return false;
        }
        return ajc$this.backendDefined.isDefined();
    }

    static final /* synthetic */ void generateScript_aroundBody8(ProxyProgramNodeContribution ajc$this, ScriptWriter writer, JoinPoint joinPoint) {
        Operation operation = ajc$this.getOperation();
        if (operation == Operation.UNDEFINED) {
            return;
        }
        ActionParameters params = ajc$this.createScripGenerationParams(operation);
        switch (operation) {
            case GRIP: {
                ajc$this.getGripActionScript(writer, params);
                break;
            }
            case RELEASE: {
                ajc$this.getReleaseActionScript(writer, params);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation " + operation);
            }
        }
        if (ajc$this.isFeedbackDetectionEnabled()) {
            writer.assign(ajc$this.getTimeoutVariable(), StepCounter.STEP_COUNT_VARIABLE);
            writer.whileCondition("True");
            writer.writeChildren();
            writer.sync();
            writer.end();
        } else {
            com.ur.polyscope.scriptwriter.ScriptWriter internalWriter = new com.ur.polyscope.scriptwriter.ScriptWriter();
            ajc$this.generateOnSuccessScriptCode(internalWriter);
            writer.appendLine(internalWriter.generateScript());
        }
    }

    static final /* synthetic */ void setConfig_aroundBody10(ProxyProgramNodeContribution ajc$this, final GripperNodeConfig config, JoinPoint joinPoint) {
        ajc$this.undoRedoManager.recordChanges(new UndoableChanges(){
            private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            public void executeChanges() {
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                Object[] objectArray = new Object[]{this, joinPoint};
                ProxyProgramNodeContribution$6$AjcClosure1 proxyProgramNodeContribution$6$AjcClosure1 = new ProxyProgramNodeContribution$6$AjcClosure1(objectArray);
                UncaughtExceptionAspect.aspectOf().aroundMethod(proxyProgramNodeContribution$6$AjcClosure1.linkClosureAndJoinPoint(69648));
            }

            static {
                6.ajc$preClinit();
            }

            static final /* synthetic */ void executeChanges_aroundBody0(6 ajc$this, JoinPoint joinPoint) {
                KeepNodeSelectionAction keepNodeSelectionAction = new KeepNodeSelectionAction(ajc$this.ProxyProgramNodeContribution.this.getRootTreeNode());
                Operation operation = Operation.convertFrom(ajc$this.config.getConfigType());
                SetOperationAction setOperationAction = new SetOperationAction(ajc$this.ProxyProgramNodeContribution.this, operation);
                keepNodeSelectionAction.append(setOperationAction);
                SetGripperConfigAction setGripperAction = new SetGripperConfigAction(ajc$this.ProxyProgramNodeContribution.this, ajc$this.config);
                keepNodeSelectionAction.append(setGripperAction);
                keepNodeSelectionAction.execute();
                ajc$this.ProxyProgramNodeContribution.this.applyPayloadConfig(ajc$this.config);
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("ProxyProgramNodeContribution.java", 6.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "executeChanges", "com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution$6", "", "", "", "void"), 503);
            }
        });
    }

    static final /* synthetic */ GripperNodeConfig getConfig_aroundBody12(ProxyProgramNodeContribution ajc$this, GripperNodeConfigBuilders gripperNodeConfigBuilders, JoinPoint joinPoint) {
        GripperNodeConfigExtractor extractor = new GripperNodeConfigExtractor();
        return extractor.extract(ajc$this, gripperNodeConfigBuilders);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ProxyProgramNodeContribution.java", ProxyProgramNodeContribution.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "openView", "com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution", "", "", "", "void"), 140);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "closeView", "com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution", "", "", "", "void"), 163);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTitle", "com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution", "", "", "", "java.lang.String"), 168);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isDefined", "com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution", "", "", "", "boolean"), 240);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "generateScript", "com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution", "com.ur.urcap.api.domain.script.ScriptWriter", "writer", "", "void"), 254);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setConfig", "com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution", "com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.GripperNodeConfig", "config", "", "void"), 500);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConfig", "com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution", "com.ur.urcap.api.contribution.driver.gripper.conformant.GripperNodeConfigBuilders", "gripperNodeConfigBuilders", "", "com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.GripperNodeConfig"), 570);
    }
}

