/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.program;

import com.ur.polyscope.gripper.internal.gripper.GripperContext;
import com.ur.polyscope.gripper.internal.gripper.params.GripperParam;
import com.ur.polyscope.gripper.internal.gripper.params.Operation;
import com.ur.polyscope.gripper.internal.gripper.program.ProgramActions;
import com.ur.polyscope.gripper.internal.gripper.program.ProgramNodeView;
import com.ur.polyscope.gripper.internal.gripper.program.actions.GripperProgramNode;
import com.ur.polyscope.gripper.internal.gripper.program.ui.ActiveOperation;
import com.ur.polyscope.gripper.resource.internal.TextResource;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;

public class TestParametersPanel {
    private final TextResource textResource;
    private final ViewContext viewContext;
    private Provider<GripperProgramNode> provider;
    private GripperContext gripperContext;
    private JButton applyParameters;

    @Inject
    public TestParametersPanel(ViewContext viewContext) {
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.viewContext = viewContext;
    }

    public void buildUI(Provider<GripperProgramNode> provider, ProgramActions actions, GripperContext gripperContext, ActiveOperation activeOperation, FormBuilder formBuilder) {
        this.provider = provider;
        this.gripperContext = gripperContext;
        WidgetFactory wf = this.viewContext.createWidgetFactory();
        this.applyParameters = wf.createButton((Action)new ProgramNodeView.TestParametersAction(this.textResource, activeOperation, actions));
        formBuilder.buttonRow((JComponent)this.applyParameters, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS});
    }

    public void initialize(Operation operation, GripperParam gripperParam) {
        if (operation == Operation.UNDEFINED) {
            this.applyParameters.setEnabled(false);
        } else {
            GripperProgramNode programNode = (GripperProgramNode)this.provider.get();
            boolean payloadValid = programNode.isPayloadValid();
            boolean enabled = this.gripperContext.isValidGripperSelected(gripperParam) && payloadValid;
            this.applyParameters.setEnabled(enabled);
        }
    }
}

