/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.program.actions;

import com.ur.polyscope.gripper.internal.gripper.program.actions.AbstractProgramTreeAction;
import com.ur.polyscope.gripper.internal.gripper.program.actions.GripperProgramNode;
import com.ur.polyscope.gripper.internal.gripper.program.outcome.SuccessNode;
import com.ur.polyscope.gripper.internal.gripper.program.outcome.TimeoutNode;
import com.ur.polyscope.program.PlaceholderOperationService;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.urcap.api.domain.program.nodes.ProgramNode;
import com.ur.urcap.api.domain.program.structure.TreeNode;
import com.ur.urcap.api.domain.program.structure.TreeStructureException;

public class ToggleFeedbackDetectionAction
extends AbstractProgramTreeAction {
    private final GripperProgramNode contribution;
    private final boolean enabled;

    public ToggleFeedbackDetectionAction(GripperProgramNode contribution, boolean enabled) {
        super(contribution.getRootTreeNode(), contribution.getTreeModificationVeto());
        this.contribution = contribution;
        this.enabled = enabled;
    }

    @Override
    public void execute() {
        this.contribution.setFeedbackDetectionEnabled(this.enabled);
        if (this.enabled) {
            this.createFeedbackSubtree(this.treeNode);
        } else {
            this.cleanSubtree();
        }
    }

    private void createFeedbackSubtree(TreeNode treeNode) {
        PlaceholderOperationService placeholder = this.contribution.getPlaceholderOperationService();
        try {
            SuccessNode successNode = new SuccessNode();
            treeNode.addChild((ProgramNode)successNode);
            TimeoutNode timeoutNode = new TimeoutNode();
            treeNode.addChild((ProgramNode)timeoutNode);
            placeholder.insertPlaceholderNodeToGivenNode((AbstractProgramNode)timeoutNode);
        }
        catch (TreeStructureException e) {
            throw new IllegalStateException("Can't create feedback subtree", e);
        }
    }
}

