/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.program.config.constraints;

import com.ur.polyscope.gripper.internal.gripper.SelectableGripperImpl;
import com.ur.polyscope.gripper.internal.gripper.program.config.NodeConfig;
import com.ur.polyscope.gripper.internal.gripper.service.GripperServiceProvider;
import com.ur.urcap.api.domain.device.gripper.GripperDevice;
import com.ur.urcap.api.domain.device.gripper.capability.MultiGripperSupport;
import com.ur.urcap.api.domain.program.nodes.contributable.device.UnsupportedConfig;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.GripperNodeConfig;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.SelectableGripper;
import com.ur.urcap.api.util.Optional;
import javax.inject.Inject;

public final class GripperSetConfigConstraints {
    private static GripperServiceProvider gripperServiceProvider;

    private GripperSetConfigConstraints() {
    }

    @Inject
    public static void setGripperServiceProvider(GripperServiceProvider gripperServiceProvider) {
        GripperSetConfigConstraints.gripperServiceProvider = gripperServiceProvider;
    }

    public static void checkIfConfigurationApplicable(GripperDevice targetDevice, GripperNodeConfig config) {
        if (targetDevice == null || config == null) {
            return;
        }
        NodeConfig nodeConfig = (NodeConfig)config;
        if (nodeConfig.isNewConfig()) {
            GripperDevice fromDevice = GripperSetConfigConstraints.getGripperDeviceFromGripperSelection(nodeConfig);
            if (fromDevice != null && !targetDevice.equals(fromDevice)) {
                GripperSetConfigConstraints.throwTargetNotSupportSelected(targetDevice, fromDevice);
            }
        } else {
            GripperDevice fromDevice = GripperSetConfigConstraints.getGripperDeviceFromConfig(nodeConfig);
            if (fromDevice != null && !targetDevice.equals(fromDevice)) {
                GripperSetConfigConstraints.throwNonMatchingDevices(targetDevice, fromDevice);
            }
        }
        if (!GripperSetConfigConstraints.isMultiGripper(targetDevice) && GripperSetConfigConstraints.hasEmptyMultigripperSelection(nodeConfig)) {
            GripperSetConfigConstraints.throwTargetNotSupportEmpty(targetDevice);
        }
    }

    private static boolean hasEmptyMultigripperSelection(NodeConfig nodeConfig) {
        return nodeConfig.isForMultiGripper() && !nodeConfig.getGripperSelection().isPresent();
    }

    private static boolean isMultiGripper(GripperDevice targetDevice) {
        Optional multi = targetDevice.getCapabilitySupport(MultiGripperSupport.class);
        return multi.isPresent();
    }

    private static GripperDevice getGripperDeviceFromGripperSelection(NodeConfig config) {
        Class contributor;
        SelectableGripper selectableGripper = GripperSetConfigConstraints.getGripperSelection(config);
        if (selectableGripper != null && (contributor = ((SelectableGripperImpl)selectableGripper).getOwningClass()) != null) {
            return gripperServiceProvider.getDevice(contributor);
        }
        return null;
    }

    private static GripperDevice getGripperDeviceFromConfig(NodeConfig config) {
        Optional deviceOptional = config.getGripperDevice();
        if (deviceOptional.isPresent()) {
            return (GripperDevice)deviceOptional.get();
        }
        return null;
    }

    private static SelectableGripper getGripperSelection(NodeConfig config) {
        Optional<SelectableGripper> selectableGripper = config.getGripperSelection();
        if (selectableGripper.isPresent()) {
            return (SelectableGripper)selectableGripper.get();
        }
        return null;
    }

    private static void throwTargetNotSupportEmpty(GripperDevice targetDevice) {
        throw new UnsupportedConfig(String.format("Config has empty multi-gripper selection but target gripper device '%s' does not support the multi-gripper capability", targetDevice.toString()));
    }

    private static void throwTargetNotSupportSelected(GripperDevice targetDevice, GripperDevice fromDevice) {
        throw new UnsupportedConfig(String.format("Config has multi-gripper selection from device '%s' that does not match target gripper device '%s'", fromDevice.toString(), targetDevice.toString()));
    }

    private static void throwNonMatchingDevices(GripperDevice targetDevice, GripperDevice fromDevice) {
        throw new UnsupportedConfig(String.format("Non-matching gripper device: Applying existing config from node using gripper device '%s' to node using gripper device '%s'", fromDevice.toString(), targetDevice.toString()));
    }
}

