/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.program.outcome.infrastructure;

import com.ur.polyscope.gripper.internal.gripper.common.actions.UndoRedoAction;
import com.ur.polyscope.gripper.internal.gripper.program.ProxyProgramNodeContribution;
import com.ur.polyscope.gripper.internal.gripper.program.actions.EnableDisableOutcomeAction;
import com.ur.polyscope.gripper.internal.gripper.program.outcome.OutcomeNode;
import com.ur.polyscope.gripper.internal.gripper.program.outcome.OutcomeParent;
import com.ur.polyscope.gripper.internal.gripper.program.outcome.SuccessNode;
import com.ur.polyscope.gripper.internal.gripper.program.outcome.TimeoutNode;
import com.ur.polyscope.gripper.internal.gripper.program.outcome.infrastructure.GripperActionPanel;
import com.ur.polyscope.gripper.resource.internal.TextResource;
import com.ur.polyscope.program.PlaceholderOperationService;
import com.ur.polyscope.program.nodes.EditProgramService;
import com.ur.swing.OnOffSwitch;
import com.ur.urcap.api.domain.undoredo.UndoRedoManager;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class GripperActionPanelImpl
extends JPanel
implements GripperActionPanel {
    private static final String ON_OFF_SWITCH_NAME = "actionSwitch.ActionPanel";
    private final OnOffSwitch onOffSwitch;
    private final String removeActionText;
    private final String addActionText;
    private OutcomeNode node;

    @Inject
    public GripperActionPanelImpl(TextResource textResource, final PlaceholderOperationService placeholderOperationService, final EditProgramService editProgramService) {
        this.removeActionText = textResource.removeAction();
        this.addActionText = textResource.addAction();
        this.setLayout(new FlowLayout(2));
        this.setBorder(new EmptyBorder(5, 10, 33, 10));
        this.onOffSwitch = new OnOffSwitch();
        this.onOffSwitch.setName(ON_OFF_SWITCH_NAME);
        this.onOffSwitch.setText(textResource.addAction());
        this.onOffSwitch.setHorizontalTextPosition(2);
        this.onOffSwitch.setHorizontalAlignment(4);
        this.onOffSwitch.setFocusable(false);
        this.onOffSwitch.setSelected(false);
        this.onOffSwitch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (GripperActionPanelImpl.this.node == null) {
                    return;
                }
                OutcomeParent parent = GripperActionPanelImpl.this.node.getParentGripNode();
                if (parent == null) {
                    return;
                }
                if (!(parent instanceof ProxyProgramNodeContribution)) {
                    return;
                }
                UndoRedoManager undoRedoManager = ((ProxyProgramNodeContribution)parent).getUndoRedoManager();
                UndoRedoAction undoRedoAction = new UndoRedoAction(undoRedoManager);
                boolean selected = GripperActionPanelImpl.this.onOffSwitch.isSelected();
                EnableDisableOutcomeAction action = new EnableDisableOutcomeAction(placeholderOperationService, editProgramService, GripperActionPanelImpl.this.node, selected);
                undoRedoAction.append(action);
                undoRedoAction.execute();
                GripperActionPanelImpl.this.setText();
            }
        });
        this.add((Component)this.onOffSwitch);
    }

    void setText() {
        this.onOffSwitch.setText(this.onOffSwitch.isSelected() ? this.removeActionText : this.addActionText);
    }

    void setToggled(final boolean allowed) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GripperActionPanelImpl.this.onOffSwitch.setSelected(allowed);
                GripperActionPanelImpl.this.setText();
            }
        });
    }

    @Override
    public void enter(Object o) {
        if (o instanceof SuccessNode) {
            this.node = (SuccessNode)o;
        } else if (o instanceof TimeoutNode) {
            this.node = (TimeoutNode)o;
        }
        this.setToggled(this.hasNodeChildren());
    }

    boolean hasNodeChildren() {
        return this.node.getChildCount() > 0;
    }

    @Override
    public void exit() {
        this.node = null;
    }

    @Override
    public JPanel getActionPanel() {
        return this;
    }
}

