/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.program.outcome.infrastructure;

import com.ur.lang.EqualsUtil;
import com.ur.polyscope.gripper.internal.gripper.program.outcome.OutcomeNode;
import com.ur.polyscope.gripper.internal.gripper.program.outcome.SuccessNode;
import com.ur.polyscope.gripper.internal.gripper.program.outcome.TimeoutNode;
import com.ur.polyscope.gripper.internal.gripper.program.ui.Style;
import com.ur.polyscope.program.commandview.ProgramTreeNodeRenderer;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.swing.SwingUtil;
import java.util.Map;
import java.util.WeakHashMap;
import javax.inject.Inject;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;

public class OutcomeTreeRenderer
implements ProgramTreeNodeRenderer {
    private final Style style;
    private final Map<AbstractProgramNode, String> cacheOfTextPerNode = new WeakHashMap<AbstractProgramNode, String>();

    @Inject
    public OutcomeTreeRenderer(Style style) {
        this.style = style;
    }

    public boolean isSupported(AbstractProgramNode node) {
        return node instanceof OutcomeNode;
    }

    public Icon getIcon(AbstractProgramNode node, boolean isNodeDefined) {
        return this.style.getOutcomeTreeIcon(isNodeDefined);
    }

    public String getText(AbstractProgramNode node, boolean isNodeDefined) {
        String result = this.getTreeNodeText(node);
        this.reloadTreeNode(node, result);
        return result;
    }

    private String getTreeNodeText(AbstractProgramNode node) {
        if (node instanceof TimeoutNode || node instanceof SuccessNode) {
            return ((OutcomeNode)node).getTitle();
        }
        throw new IllegalArgumentException("Unsupported program node:" + node.getClass());
    }

    private void reloadTreeNode(AbstractProgramNode node, String text) {
        String prevText = this.cacheOfTextPerNode.get(node);
        if (!EqualsUtil.equals((Object)text, (Object)prevText)) {
            this.reloadTreeNode(node);
            this.cacheOfTextPerNode.put(node, text);
        }
    }

    private void reloadTreeNode(final AbstractProgramNode node) {
        SwingUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                node.getProgramTreeModel().reload((TreeNode)node);
            }
        });
    }
}

