/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.program.outcome.infrastructure;

import com.ur.polyscope.gripper.internal.gripper.program.outcome.OutcomeParent;
import com.ur.polyscope.gripper.internal.gripper.program.outcome.SuccessNode;
import com.ur.polyscope.gripper.internal.gripper.program.outcome.infrastructure.GripperActionPanel;
import com.ur.polyscope.gripper.resource.internal.TextResource;
import com.ur.polyscope.program.commandview.UpdateCard;
import com.ur.swing.CardPanel;
import com.ur.swing.FormBuilder;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.util.swing.HTML;
import java.awt.BorderLayout;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class SuccessCard
extends CardPanel
implements UpdateCard<SuccessNode> {
    public static final String SUCCESS_CARD = "SuccessCard";
    private final GripperActionPanel gripperActionPanel;
    private final JLabel lblHeader;
    private final JLabel lblDescription;
    private final JLabel lblAddActionDescription;
    private final JLabel lblPayloadDescription;
    private final String gripDetectedText;
    private final String gripDetectedDescription;
    private final String gripDetectedAddActionDescription;
    private final String releaseDetected;
    private final String releaseDetectedDescription;
    private final String releaseDetectedAddActionDescription;

    @Inject
    public SuccessCard(ViewContext context, GripperActionPanel gripperActionPanel, URFontFactory fontFactory) {
        this.gripperActionPanel = gripperActionPanel;
        WidgetFactory widgetFactory = context.createWidgetFactory();
        this.lblHeader = widgetFactory.createLabel("");
        this.lblDescription = widgetFactory.createLabel("");
        this.lblAddActionDescription = widgetFactory.createLabel("");
        this.lblPayloadDescription = widgetFactory.createLabel("");
        TextResource textResource = (TextResource)context.getTextResource(TextResource.class);
        this.gripDetectedText = textResource.gripDetected();
        this.gripDetectedDescription = HTML.html((String)textResource.gripDetectedDescription());
        this.gripDetectedAddActionDescription = HTML.html((String)textResource.gripDetectedAddActionDescription());
        this.releaseDetected = textResource.releaseDetected();
        this.releaseDetectedDescription = HTML.html((String)textResource.releaseDetectedDescription());
        this.releaseDetectedAddActionDescription = HTML.html((String)textResource.releaseDetectedAddActionDescription());
        this.setLayout(new BorderLayout());
        this.add(this.createView(context, fontFactory), "Center");
        this.add(gripperActionPanel.getActionPanel(), "South");
        this.setName(SUCCESS_CARD);
    }

    private JComponent createView(ViewContext context, URFontFactory fontFactory) {
        FormBuilder builder = context.createFormBuilder();
        this.lblHeader.setFont(fontFactory.getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.MAIN_HEADING_SIZE));
        this.lblDescription.setVerticalAlignment(1);
        this.lblAddActionDescription.setVerticalAlignment(1);
        return builder.component((JComponent)this.lblHeader, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS}).end(2).component((JComponent)this.lblDescription, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).component((JComponent)this.lblAddActionDescription, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end().component((JComponent)this.lblPayloadDescription, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).end(8).getPanel();
    }

    public void enter(Object o) {
        super.enter(o);
        this.gripperActionPanel.enter(o);
    }

    public Object exit() {
        this.gripperActionPanel.exit();
        return super.exit();
    }

    public void updateCard(SuccessNode successNode) {
        OutcomeParent parentNode = successNode.getParentGripNode();
        if (parentNode == null) {
            return;
        }
        switch (parentNode.getOperation()) {
            case GRIP: {
                this.lblHeader.setText(this.gripDetectedText);
                this.lblDescription.setText(this.gripDetectedDescription);
                this.lblAddActionDescription.setText(this.gripDetectedAddActionDescription);
                break;
            }
            case RELEASE: {
                this.lblHeader.setText(this.releaseDetected);
                this.lblDescription.setText(this.releaseDetectedDescription);
                this.lblAddActionDescription.setText(this.releaseDetectedAddActionDescription);
                break;
            }
        }
    }
}

