/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.program.outcome.infrastructure;

import com.ur.lang.DecimalFormatFactory;
import com.ur.polyscope.gripper.internal.gripper.params.Operation;
import com.ur.polyscope.gripper.internal.gripper.program.outcome.OutcomeParent;
import com.ur.polyscope.gripper.internal.gripper.program.outcome.TimeoutNode;
import com.ur.polyscope.gripper.internal.gripper.program.outcome.infrastructure.GripperActionPanel;
import com.ur.polyscope.gripper.resource.internal.TextResource;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.polyscope.program.commandview.UpdateCard;
import com.ur.polyscope.valueobjects.Time;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.CardPanel;
import com.ur.swing.FormBuilder;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.number.NumberField;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.swing.HTML;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.tree.TreeNode;

public class TimeoutCard
extends CardPanel
implements UpdateCard<TimeoutNode> {
    private static final Logger LOG = LogFactory.createLogger(TimeoutCard.class);
    private static final String TIMEOUT_NAME = "timeout.TimeoutCard";
    private final GripperActionPanel gripperActionPanel;
    private NumberField timeout;
    private TimeoutNode node;
    private JLabel lblDescription;
    private JLabel lblHeader;
    private final String gripTimeoutCardTitleText;
    private final String timeoutCardDescriptionText;
    private final String releaseTimeoutCardTitleText;
    private final String timeoutCardDescriptionForReleaseText;
    private final String timeoutWithinRangeText;
    private final String timeoutInSecondsText;

    @Inject
    public TimeoutCard(ViewContext context, GripperActionPanel gripperActionPanel, URFontFactory fontFactory) {
        this.gripperActionPanel = gripperActionPanel;
        TextResource textResource = (TextResource)context.getTextResource(TextResource.class);
        this.gripTimeoutCardTitleText = textResource.gripTimeoutCardTitle();
        this.timeoutCardDescriptionText = HTML.html((String)textResource.timeoutCardDescription());
        this.releaseTimeoutCardTitleText = textResource.releaseTimeoutCardTitle();
        this.timeoutCardDescriptionForReleaseText = HTML.html((String)textResource.timeoutCardDescriptionForRelease());
        this.timeoutWithinRangeText = textResource.timeoutWithinRange();
        this.timeoutInSecondsText = textResource.timeoutInSeconds();
        this.setLayout(new BorderLayout());
        this.add(this.createView(context, fontFactory), "Center");
        this.add(gripperActionPanel.getActionPanel(), "South");
    }

    private JComponent createView(ViewContext context, URFontFactory fontFactory) {
        FormBuilder builder = context.createFormBuilder();
        this.lblDescription = context.createWidgetFactory().createLabel("");
        this.lblDescription.setVerticalAlignment(1);
        this.lblHeader = context.createWidgetFactory().createLabel("");
        this.lblHeader.setFont(fontFactory.getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.MAIN_HEADING_SIZE));
        this.timeout = context.createWidgetFactory().createNumberField((ActionListener)new UpdateModelListener(), UnitsValueConverterFactory.getTimeConverter((boolean)true));
        this.timeout.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"0.0"));
        this.timeout.setName(TIMEOUT_NAME);
        this.timeout.setErrorValidationStrategy(new ValidationStrategy[]{ValidationFactory.getRangeValidator((double)0.0, (double)120.0, (String)this.timeoutWithinRangeText)});
        return builder.component((JComponent)this.lblHeader, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS}).end(2).component((JComponent)this.lblDescription, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(3).label(this.timeoutInSecondsText, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS}).end().component((JComponent)this.timeout, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().getPanel();
    }

    public void enter(Object o) {
        super.enter(o);
        this.gripperActionPanel.enter(o);
        this.node = (TimeoutNode)o;
    }

    public Object exit() {
        this.gripperActionPanel.exit();
        this.node = null;
        return super.exit();
    }

    public void updateCard(TimeoutNode timeoutNode) {
        OutcomeParent parentNode = timeoutNode.getParentGripNode();
        if (parentNode == null) {
            return;
        }
        Time value = this.node.getTimeout();
        this.timeout.setValue((Object)value);
        Operation operation = parentNode.getOperation();
        switch (operation) {
            case GRIP: {
                this.lblHeader.setText(this.gripTimeoutCardTitleText);
                this.lblDescription.setText(this.timeoutCardDescriptionText);
                break;
            }
            case RELEASE: {
                this.lblHeader.setText(this.releaseTimeoutCardTitleText);
                this.lblDescription.setText(this.timeoutCardDescriptionForReleaseText);
                break;
            }
        }
    }

    private class UpdateModelListener
    implements ActionListener {
        private UpdateModelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Time value = (Time)TimeoutCard.this.timeout.getValue();
            LOG.debug("Update timeout", new Object[]{value});
            TimeoutCard.this.node.setTimeout(value);
            TimeoutCard.this.node.getProgramTreeModel().reload((TreeNode)((Object)TimeoutCard.this.node));
        }
    }
}

