/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.program.outcome.infrastructure;

import com.ur.polyscope.gripper.internal.gripper.program.outcome.TimeoutNode;
import com.ur.polyscope.persistence.PersistReader;
import com.ur.polyscope.persistence.PersistWriter;
import com.ur.polyscope.program.persist.ProgramComponentConversionStrategy;
import com.ur.polyscope.valueobjects.Time;
import java.util.Collections;
import java.util.Map;

public class TimeoutNodeConversionStrategy
implements ProgramComponentConversionStrategy<TimeoutNode> {
    public static final String NODE_NAME = "Timeout";

    public Class<TimeoutNode> getSupportedType() {
        return TimeoutNode.class;
    }

    public boolean canUnmarshalFrom(PersistReader reader) {
        return NODE_NAME.equals(reader.getNodeName());
    }

    public void marshal(TimeoutNode toMarshal, PersistWriter writer) {
        writer.addAttribute("timeoutInSeconds", toMarshal.getTimeout().getIn(Time.Unit.SECONDS));
    }

    public TimeoutNode unmarshal(PersistReader reader) {
        TimeoutNode node = new TimeoutNode();
        node.setTimeout(Time.from((double)reader.getDoubleAttribute("timeoutInSeconds"), (Time.Unit)Time.Unit.SECONDS));
        return node;
    }

    public Map<String, Class<? extends TimeoutNode>> getClassAliases(boolean forMarshalling) {
        return Collections.emptyMap();
    }

    public Map<String, Class<? extends TimeoutNode>> getTypeAliases(boolean forMarshalling) {
        return Collections.singletonMap(NODE_NAME, TimeoutNode.class);
    }
}

