/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.program.payload;

import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadWithMassOnly;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.swing.units.ValueConverter;
import com.ur.urcap.api.domain.payload.Payload;
import com.ur.urcap.api.domain.value.simple.Mass;

public final class PayloadConstants {
    public static final ValueConverter<String, Weight> MASS_CONVERTER = UnitsValueConverterFactory.getWeightConverter();
    public static final double EMPTY_PAYLOAD_WEIGHT = Double.POSITIVE_INFINITY;
    public static final Mass EMPTY_MASS = Weight.from((double)Double.POSITIVE_INFINITY, (Mass.Unit)Mass.Unit.KG);
    public static final Payload EMPTY = new PayloadWithMassOnly(EMPTY_MASS);
    public static final Payload ZERO = new PayloadWithMassOnly(Weight.from((double)0.0, (Mass.Unit)Mass.Unit.KG));

    private PayloadConstants() {
    }

    public static boolean isEmpty(Mass mass) {
        if (mass == null) {
            return true;
        }
        double massInKg = mass.getAs(Mass.Unit.KG);
        return massInKg == Double.POSITIVE_INFINITY;
    }

    public static String getProgramTreeValue(Mass mass) {
        if (!PayloadConstants.isEmpty(mass)) {
            String massString = PayloadConstants.getMassString((Weight)mass);
            return String.valueOf(massString) + " " + MASS_CONVERTER.getUnit();
        }
        return "";
    }

    public static String getMassString(Weight mass) {
        String massString = MASS_CONVERTER.getFormat().format(Double.parseDouble((String)MASS_CONVERTER.fromModel((Object)mass)));
        if (massString.endsWith(".000")) {
            return massString.replace(".000", "");
        }
        if (massString.endsWith(",000")) {
            return massString.replace(",000", "");
        }
        return massString;
    }
}

