/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.program.payload.ui;

import com.ur.lang.PrimitiveUtils;
import com.ur.lang.StringUtils;
import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadConstants;
import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadNotSelected;
import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadPanel;
import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadWithMassOnly;
import com.ur.polyscope.gripper.internal.gripper.program.payload.ui.PayloadComboboxModel;
import com.ur.polyscope.gripper.resource.internal.TextResource;
import com.ur.polyscope.payload.common.PayloadRenderingStrategyProvider;
import com.ur.polyscope.payload.common.PayloadValidationRules;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.swing.ComboBox;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.FormBuilder;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.ViewContext;
import com.ur.swing.WideDropDownRenderer;
import com.ur.swing.WidgetFactory;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.renderers.contributed.ContributedComboBoxRenderer;
import com.ur.swing.validation.AutoCorrectionValidator;
import com.ur.swing.validation.PayloadValidation;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.urcap.api.domain.payload.Payload;
import com.ur.urcap.api.domain.value.simple.Mass;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.inject.Inject;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.PopupMenuListener;

public class PayloadPanelImpl
implements PayloadPanel {
    private static final String PAYLOAD_PANEL_USE_PAYLOAD = "PayloadPanel.UsePayload";
    private static final String PAYLOAD_PANEL_SELECTION = "PayloadPanel.Selection";
    private static final String PAYLOAD_PANEL_MASS = "PayloadPanel.Mass";
    private static final String PAYLOAD_PANEL_COMBOBOX = "PayloadPanel.ComboBox";
    private static final boolean CANNOT_BE_EMPTY = false;
    private static final boolean SOFT_VALUE = false;
    private static final boolean HARD_VALUE = true;
    private final JCheckBox usePayloadCheckBox;
    protected final NumberField massNumberField;
    private final JLabel massLabel;
    private final JComboBox payloadSelectionComboBox;
    private final PayloadComboboxModel model;
    protected final PayloadValidationRules payloadValidationRules;
    private final com.ur.polyscope.payload.TextResource payloadApiTextResource;
    private PayloadPanel.PayloadPanelListener panelListener;
    private volatile boolean updatingComboboxModel = false;

    @Inject
    public PayloadPanelImpl(PayloadComboboxModel model, PayloadValidation payloadValidation, ViewContext viewContext, PayloadRenderingStrategyProvider rendererProvider, PayloadValidationRules payloadValidationRules, com.ur.polyscope.payload.TextResource payloadApiTextResource) {
        this.model = model;
        this.payloadValidationRules = payloadValidationRules;
        this.payloadApiTextResource = payloadApiTextResource;
        TextResource textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        WidgetFactory widgetFactory = viewContext.createWidgetFactory();
        this.usePayloadCheckBox = this.createCheckBox(textResource);
        this.payloadSelectionComboBox = this.createComboBox(widgetFactory, rendererProvider);
        this.payloadSelectionComboBox.setModel(model);
        this.payloadSelectionComboBox.setName(PAYLOAD_PANEL_COMBOBOX);
        this.massLabel = widgetFactory.createLabel(textResource.Mass());
        this.massLabel.setHorizontalAlignment(4);
        this.massLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.massNumberField = this.createNumberField(payloadValidation);
    }

    private JComboBox createComboBox(WidgetFactory widgetFactory, PayloadRenderingStrategyProvider rendererProvider) {
        ComboBox comboBox = widgetFactory.createComboBox();
        RenderingStrategy renderingStrategy = rendererProvider.getPayloadRenderingStrategy();
        comboBox.setRenderer(new ContributedComboBoxRenderer(renderingStrategy));
        comboBox.addPopupMenuListener((PopupMenuListener)new WideDropDownRenderer(renderingStrategy, 500));
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PayloadPanelImpl.this.onComboboxSelectionChanged();
                }
            }
        });
        return comboBox;
    }

    private NumberField createNumberField(PayloadValidation payloadValidation) {
        NumberField field = new NumberField(PayloadConstants.MASS_CONVERTER, true){

            public void setBackground(Color color) {
                2 field = this;
                color = PayloadPanelImpl.this.defineMassFieldBackground(color, field);
                super.setBackground(color);
            }
        };
        field.setUnitWidth(55);
        field.setColumns(7);
        field.setName(PAYLOAD_PANEL_MASS);
        field.setMode(Mode.PositiveNumbers);
        AutoCorrectionValidator errorValidator = payloadValidation.getPayloadValidator(true, false);
        field.setErrorValidationStrategy(new ValidationStrategy[]{errorValidator});
        AutoCorrectionValidator warningValidator = payloadValidation.getPayloadValidator(false, false);
        ValidationStrategy.Composite warningValidationStrategy = new ValidationStrategy.Composite(new ValidationStrategy[]{warningValidator, this.getMassValidationStrategy()});
        field.setWarningValidationStrategy(new ValidationStrategy[]{warningValidationStrategy});
        field.addActionListener((ActionListener)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PayloadPanelImpl.this.onMassNumberFieldChanged();
            }
        });
        return field;
    }

    protected Color defineMassFieldBackground(Color color, NumberField field) {
        if (!field.isEnabled()) {
            color = DisplayMessageFactory.OK_COLOR;
        } else if (field.getDocument() != null && StringUtils.isNullOrOnlyWhitespace((String)field.getText())) {
            color = DisplayMessageFactory.WARNING_COLOR;
        }
        return color;
    }

    private JCheckBox createCheckBox(TextResource textResource) {
        JCheckBox checkBox = new JCheckBox(textResource.setTotalPayload());
        checkBox.setFocusable(false);
        checkBox.setName(PAYLOAD_PANEL_USE_PAYLOAD);
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PayloadPanelImpl.this.onCheckBoxSelectionChanged();
            }
        });
        return checkBox;
    }

    @Override
    public void close() {
        PayloadPanel.PayloadPanelListener restore = this.panelListener;
        this.panelListener = null;
        try {
            this.model.removeAllElements();
        }
        finally {
            this.panelListener = restore;
        }
    }

    @Override
    public void layout(FormBuilder formBuilder) {
        formBuilder.component((JComponent)this.usePayloadCheckBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS}).end();
        formBuilder.component((JComponent)this.payloadSelectionComboBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS, FormBuilder.PanelConstraints.INDENT}).component((JComponent)this.massLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.massNumberField, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end();
        formBuilder.end();
    }

    public void layoutToolbar(FormBuilder formBuilder) {
        formBuilder.component((JComponent)this.usePayloadCheckBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS}).end();
        JPanel payloadSelectionPanel = new JPanel();
        payloadSelectionPanel.setLayout(new BoxLayout(payloadSelectionPanel, 2));
        payloadSelectionPanel.setBorder(BorderFactory.createEmptyBorder());
        this.payloadSelectionComboBox.setPreferredSize(new Dimension(300, 0));
        payloadSelectionPanel.add(this.payloadSelectionComboBox);
        payloadSelectionPanel.add(Box.createRigidArea(new Dimension(15, 0)));
        payloadSelectionPanel.add(this.massLabel);
        payloadSelectionPanel.add((Component)this.massNumberField);
        formBuilder.component((JComponent)payloadSelectionPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS, FormBuilder.PanelConstraints.INDENT}).end();
        formBuilder.end();
    }

    @Override
    public void update(boolean enabled, boolean usePayload, Payload payload) {
        PayloadPanel.PayloadPanelListener restore = this.panelListener;
        this.panelListener = null;
        try {
            this.usePayloadCheckBox.setEnabled(enabled);
            boolean subComponentEnabled = enabled && this.usePayloadCheckBox.isSelected();
            this.payloadSelectionComboBox.setEnabled(subComponentEnabled);
            this.usePayloadCheckBox.setSelected(usePayload);
            this.updatePayloadCombobox(usePayload, payload);
        }
        finally {
            this.panelListener = restore;
        }
    }

    @Override
    public void setModifyListener(PayloadPanel.PayloadPanelListener listener) {
        this.panelListener = listener;
    }

    private void updatePayloadCombobox(boolean usePayload, Payload payload) {
        boolean comboboxEnabled = this.usePayloadCheckBox.isEnabled() && usePayload;
        this.updatingComboboxModel = true;
        this.payloadSelectionComboBox.setEnabled(comboboxEnabled);
        this.model.update(payload);
        this.updateMassField(payload);
        this.updatingComboboxModel = false;
    }

    protected void updateMassField(Payload payload) {
        if (payload == null || payload instanceof PayloadNotSelected || !payload.isResolvable()) {
            this.massLabel.setEnabled(false);
            this.massNumberField.setEnabled(false);
            this.massNumberField.setText("");
            this.massNumberField.setBackground(DisplayMessageFactory.OK_COLOR);
        } else if (payload instanceof PayloadWithMassOnly) {
            this.massLabel.setEnabled(this.payloadSelectionComboBox.isEnabled());
            this.massNumberField.setAllowToolTip(false);
            this.massNumberField.setEnabled(this.payloadSelectionComboBox.isEnabled());
            if (PayloadConstants.isEmpty(payload.getMass())) {
                this.massNumberField.setText("");
                this.massNumberField.setBackground(DisplayMessageFactory.WARNING_COLOR);
            } else {
                Mass mass = payload.getMass();
                this.massNumberField.setValue((Object)mass);
            }
        } else {
            this.massLabel.setEnabled(false);
            this.massNumberField.setEnabled(false);
            Mass mass = payload.getMass();
            this.massNumberField.setValue((Object)mass);
        }
    }

    private void onCheckBoxSelectionChanged() {
        boolean usePayload = this.usePayloadCheckBox.isSelected();
        this.payloadSelectionComboBox.setEnabled(usePayload);
        PayloadNotSelected payload = !usePayload ? new PayloadNotSelected() : (Payload)this.payloadSelectionComboBox.getSelectedItem();
        this.updateMassField(payload);
        if (this.panelListener != null) {
            this.panelListener.onPayloadModified(usePayload, payload);
        }
    }

    private void onComboboxSelectionChanged() {
        if (this.updatingComboboxModel) {
            return;
        }
        Object selected = this.payloadSelectionComboBox.getSelectedItem();
        Payload payload = (Payload)selected;
        if (payload instanceof PayloadWithMassOnly) {
            payload = new PayloadWithMassOnly(PayloadConstants.EMPTY_MASS);
        }
        this.updateMassField(payload);
        if (this.panelListener != null) {
            this.panelListener.onPayloadModified(this.usePayloadCheckBox.isSelected(), payload);
        }
    }

    private void onMassNumberFieldChanged() {
        Weight mass = (Weight)this.massNumberField.getValue();
        PayloadWithMassOnly payload = new PayloadWithMassOnly((Mass)mass);
        if (PayloadConstants.isEmpty(payload.getMass())) {
            this.massNumberField.setText("");
            this.massNumberField.setBackground(DisplayMessageFactory.WARNING_COLOR);
        }
        if (this.panelListener != null) {
            this.panelListener.onPayloadModified(this.usePayloadCheckBox.isSelected(), payload);
        }
    }

    public void setName(String name) {
        this.usePayloadCheckBox.setName(String.valueOf(name) + "." + PAYLOAD_PANEL_USE_PAYLOAD);
        this.payloadSelectionComboBox.setName(String.valueOf(name) + "." + PAYLOAD_PANEL_SELECTION);
        this.massNumberField.setName(String.valueOf(name) + "." + PAYLOAD_PANEL_MASS);
    }

    private ValidationStrategy getMassValidationStrategy() {
        return new ValidationStrategy(){

            public boolean isValid(String s) {
                double mass = PrimitiveUtils.parseDouble((String)s, (double)0.0);
                return !PayloadPanelImpl.this.payloadValidationRules.isMassZero(Weight.from((double)mass, (Mass.Unit)Mass.Unit.KG));
            }

            public String getErrorMessage(String s) {
                return PayloadPanelImpl.this.payloadApiTextResource.rememberPayloadWarningField();
            }
        };
    }
}

