/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.program.payload.ui;

import com.ur.lang.StringUtils;
import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadNotSelected;
import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadWithMassOnly;
import com.ur.polyscope.gripper.internal.gripper.program.payload.ui.PayloadComboboxModel;
import com.ur.polyscope.gripper.internal.gripper.program.payload.ui.PayloadPanelImpl;
import com.ur.polyscope.payload.TextResource;
import com.ur.polyscope.payload.common.PayloadRenderingStrategyProvider;
import com.ur.polyscope.payload.common.PayloadValidationRules;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.number.NumberField;
import com.ur.swing.validation.PayloadValidation;
import com.ur.urcap.api.domain.payload.Payload;
import com.ur.urcap.api.domain.value.Position;
import com.ur.urcap.api.domain.value.simple.Mass;
import java.awt.Color;
import javax.inject.Inject;

public class PayloadToolbarPanelImpl
extends PayloadPanelImpl {
    @Inject
    public PayloadToolbarPanelImpl(PayloadComboboxModel model, PayloadValidation payloadValidation, ViewContext viewContext, PayloadRenderingStrategyProvider rendererProvider, PayloadValidationRules payloadValidationRules, TextResource payloadApiTextResource) {
        super(model, payloadValidation, viewContext, rendererProvider, payloadValidationRules, payloadApiTextResource);
    }

    @Override
    protected Color defineMassFieldBackground(Color color, NumberField field) {
        if (field.getDocument() != null && StringUtils.isNullOrOnlyWhitespace((String)field.getText()) && !field.isEnabled()) {
            color = DisplayMessageFactory.OK_COLOR;
        } else if (field.getDocument() != null && StringUtils.isNullOrOnlyWhitespace((String)field.getText())) {
            color = DisplayMessageFactory.WARNING_COLOR;
        }
        return color;
    }

    @Override
    protected void updateMassField(Payload payload) {
        Position cog;
        super.updateMassField(payload);
        if (payload == null || payload instanceof PayloadNotSelected || !payload.isResolvable()) {
            return;
        }
        if (payload instanceof PayloadWithMassOnly) {
            return;
        }
        Mass mass = payload.getMass();
        if (!this.payloadValidationRules.isMassAndCOGValid(mass, cog = payload.getCenterOfGravity()) || this.payloadValidationRules.isMassZero(mass)) {
            this.massNumberField.setBackground(DisplayMessageFactory.WARNING_COLOR);
        } else {
            this.massNumberField.setBackground(DisplayMessageFactory.OK_COLOR);
        }
    }
}

