/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.program.ui;

import com.ur.polyscope.gripper.internal.gripper.params.Operation;
import com.ur.polyscope.gripper.internal.gripper.program.actions.GripperProgramNode;
import com.ur.polyscope.gripper.internal.gripper.program.ui.GripReleaseDetectionToggle;
import com.ur.polyscope.gripper.internal.gripper.program.ui.Style;
import com.ur.polyscope.gripper.internal.gripper.program.ui.UIToggleFeedbackDetectionAction;
import com.ur.polyscope.gripper.internal.resources.ImageResource;
import com.ur.polyscope.gripper.resource.internal.TextResource;
import com.ur.polyscope.installation.urcap.proxy.Defined;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.util.swing.HTML;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.JLabel;

public class FooterPanel {
    public static final String WARNING_NAME = "undefinedWarning";
    private static final Logger LOG = LogFactory.createLogger(FooterPanel.class);
    private final Style style;
    private final WidgetFactory widgetFactory;
    private final TextResource textResource;
    private Provider<GripperProgramNode> contributionProvider;
    private Defined backendService;
    private GripReleaseDetectionToggle gripReleaseDetectionToggle;
    private JLabel warningLabel;
    private String undefinedWarningText;
    private String multiGripperWarningText;

    @Inject
    public FooterPanel(Style style, ViewContext context) {
        this.style = style;
        ViewContext viewContext = context;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.widgetFactory = viewContext.createWidgetFactory();
    }

    public void buildUI(Provider<GripperProgramNode> provider, String gripperTitle, Defined backendDefined, FormBuilder formBuilder) {
        this.contributionProvider = provider;
        this.undefinedWarningText = this.textResource.undefinedWarning(gripperTitle);
        this.multiGripperWarningText = this.textResource.multiGripperWarning(gripperTitle);
        this.backendService = backendDefined;
        this.warningLabel = this.createTestButtonsSection(this.widgetFactory);
        this.gripReleaseDetectionToggle = this.createGripReleaseDetectionToggleSection(this.textResource, this.widgetFactory);
        this.style.createFooter(formBuilder, this.widgetFactory, this.warningLabel, this.gripReleaseDetectionToggle.getComponent());
    }

    private JLabel createTestButtonsSection(WidgetFactory widgetFactory) {
        JLabel result = widgetFactory.createLabel("");
        result.setIcon(ImageResource.warning());
        result.setVerticalTextPosition(1);
        result.setVerticalAlignment(1);
        result.setName(WARNING_NAME);
        return result;
    }

    private GripReleaseDetectionToggle createGripReleaseDetectionToggleSection(TextResource textResource, WidgetFactory widgetFactory) {
        UIToggleFeedbackDetectionAction action = new UIToggleFeedbackDetectionAction(this.contributionProvider);
        return this.style.createGripReleaseDetectionToggle(widgetFactory, textResource, action);
    }

    public void initialize(Operation operation) {
        GripperProgramNode contribution = (GripperProgramNode)this.contributionProvider.get();
        try {
            this.gripReleaseDetectionToggle.setToggled(contribution.isFeedbackDetectionEnabled());
            this.gripReleaseDetectionToggle.setSupportGripReleaseDetection(contribution.isFeedbackDetectionSupported(Operation.GRIP), contribution.isFeedbackDetectionSupported(Operation.RELEASE));
            this.gripReleaseDetectionToggle.setOperation(operation);
            this.gripReleaseDetectionToggle.update();
        }
        catch (IllegalStateException ise) {
            LOG.debug("When generating the TimeoutNode, the child being added throws an exception (but still works)", (Throwable)ise);
        }
        boolean showMultiGripperWarning = contribution.isMultiGripper() && !contribution.isMultiGripperSelectionPossible() && contribution.getSelectedGripper() == null;
        boolean showUndefinedWarning = !this.backendService.isDefined();
        this.warningLabel.setVisible(showUndefinedWarning || showMultiGripperWarning);
        String warningLabelText = showMultiGripperWarning ? this.multiGripperWarningText : this.undefinedWarningText;
        this.warningLabel.setText(this.formatLongerText(warningLabelText));
    }

    private String formatLongerText(String text) {
        if (text == null) {
            return text;
        }
        String size = "3";
        if (Locale.getDefault().getLanguage().matches("en") || Locale.getDefault().getLanguage().matches("us")) {
            size = "4";
        }
        return HTML.html((String)HTML.p((String)HTML.fontSize((String)size, (String)text)));
    }
}

