/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.program.ui;

import com.ur.polyscope.gripper.internal.gripper.common.widgets.ToggleImpl;
import com.ur.polyscope.gripper.internal.gripper.params.Operation;
import com.ur.polyscope.gripper.internal.gripper.program.ui.GripReleaseDetectionToggle;
import com.ur.polyscope.gripper.resource.internal.TextResource;
import com.ur.swing.OnOffSwitch;
import javax.swing.Action;

public class GripReleaseDetectionToggleImpl
extends ToggleImpl
implements GripReleaseDetectionToggle {
    private final String handleGripReleaseDetectionText;
    private final String handleGripDetectionText;
    private final String handleReleaseDetectionText;
    private boolean supportGripDetection;
    private boolean supportReleaseDetection;
    private Operation operation;

    public GripReleaseDetectionToggleImpl(TextResource textResource, Action action, OnOffSwitch onOffSwitch) {
        super(action, onOffSwitch);
        this.handleGripReleaseDetectionText = textResource.handleGripReleaseDetection();
        this.handleGripDetectionText = textResource.handleGripDetection();
        this.handleReleaseDetectionText = textResource.handleReleaseDetection();
    }

    @Override
    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    @Override
    public void setSupportGripReleaseDetection(boolean gripDetectionSupported, boolean releaseDetectionSupported) {
        this.supportGripDetection = gripDetectionSupported;
        this.supportReleaseDetection = releaseDetectionSupported;
    }

    @Override
    public void update() {
        switch (this.operation) {
            case GRIP: {
                this.updateGripDetectionText();
                break;
            }
            case RELEASE: {
                this.updateReleaseDetectionText();
                break;
            }
            default: {
                this.updateUndefinedOperationText();
            }
        }
    }

    private void updateReleaseDetectionText() {
        if (this.supportReleaseDetection) {
            this.setText(this.handleReleaseDetectionText);
            this.setEnabled(true);
            this.setVisible(true);
        } else {
            this.setEnabled(false);
            this.setVisible(false);
        }
    }

    private void updateGripDetectionText() {
        if (this.supportGripDetection) {
            this.setText(this.handleGripDetectionText);
            this.setEnabled(true);
            this.setVisible(true);
        } else {
            this.setEnabled(false);
            this.setVisible(false);
        }
    }

    private void updateUndefinedOperationText() {
        this.setEnabled(false);
        if (this.supportReleaseDetection && this.supportGripDetection) {
            this.setText(this.handleGripReleaseDetectionText);
            this.setVisible(true);
        } else if (this.supportGripDetection) {
            this.setText(this.handleGripDetectionText);
            this.setVisible(true);
        } else if (this.supportReleaseDetection) {
            this.setText(this.handleReleaseDetectionText);
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
    }
}

