/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.service.impl;

import com.ur.polyscope.gripper.internal.gripper.device.impl.GripperDeviceImpl;
import com.ur.polyscope.gripper.internal.gripper.service.GripperServiceProvider;
import com.ur.polyscope.gripper.internal.gripper.util.Identifiable;
import com.ur.polyscope.urcaps.device.URCapServiceProvider;
import com.ur.polyscope.urcaps.nodeservices.URCapClassResolver;
import com.ur.urcap.api.contribution.ProgramNodeService;
import com.ur.urcap.api.contribution.URCapProgramNodeService;
import com.ur.urcap.api.contribution.program.swing.SwingProgramNodeService;
import com.ur.urcap.api.domain.URCapInfo;
import com.ur.urcap.api.domain.device.gripper.GripperDevice;
import com.ur.urcap.api.domain.system.localization.Localization;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class GripperServiceProviderImpl
implements GripperServiceProvider {
    private final HashMap<GripperDevice, Class> deviceMap = new HashMap();
    private final URCapServiceProvider urCapServiceProvider;
    private final Locale locale;
    private final Comparator<GripperDevice> comparator;
    private List<GripperDevice> gripperDevices;

    @Inject
    public GripperServiceProviderImpl(URCapServiceProvider urCapServiceProvider, Localization localization) {
        this.urCapServiceProvider = urCapServiceProvider;
        this.locale = localization.getLocale();
        this.comparator = this.createComparator();
        this.gripperDevices = this.createSortedGripperDeviceList();
    }

    @Override
    public GripperDevice add(URCapProgramNodeService service) {
        GripperDevice newGripperDevice = this.createGripperDevice(service);
        String id = this.getId(newGripperDevice);
        Class serviceClass = URCapClassResolver.getURCapClass((URCapProgramNodeService)service);
        if (!this.isGripperDevicePresent(serviceClass, id)) {
            this.deviceMap.put(newGripperDevice, serviceClass);
            this.gripperDevices = this.createSortedGripperDeviceList();
        }
        return newGripperDevice;
    }

    private GripperDevice createGripperDevice(URCapProgramNodeService service) {
        Class serviceClass = URCapClassResolver.getURCapClass((URCapProgramNodeService)service);
        URCapInfo urCapInfo = this.urCapServiceProvider.getURCapInfo(serviceClass);
        String id = serviceClass.getName();
        String gripperName = this.getGripperName(service, urCapInfo.getName());
        return new GripperDeviceImpl(urCapInfo, gripperName, id, true);
    }

    private String getGripperName(URCapProgramNodeService service, String defaultTitle) {
        if (service instanceof SwingProgramNodeService) {
            return ((SwingProgramNodeService)service).getTitle(this.locale);
        }
        if (service instanceof ProgramNodeService) {
            return ((ProgramNodeService)service).getTitle();
        }
        return defaultTitle;
    }

    @Override
    public Class getServiceClass(GripperDevice gripperDevice) {
        return this.deviceMap.get(gripperDevice);
    }

    @Override
    public List<GripperDevice> getGrippers() {
        return this.gripperDevices;
    }

    @Override
    public GripperDevice getDevice(Class service) {
        for (Map.Entry<GripperDevice, Class> entry : this.deviceMap.entrySet()) {
            if (!entry.getValue().equals(service)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public GripperDevice getDevice(String urCapSymbolicName, String deviceId) {
        for (Map.Entry<GripperDevice, Class> entry : this.deviceMap.entrySet()) {
            GripperDevice gripperDevice = entry.getKey();
            if (!this.isGripperDevice(gripperDevice, urCapSymbolicName, deviceId)) continue;
            return gripperDevice;
        }
        return null;
    }

    private List<GripperDevice> createSortedGripperDeviceList() {
        ArrayList<GripperDevice> gripperDeviceList = new ArrayList<GripperDevice>(this.deviceMap.keySet());
        Collections.sort(gripperDeviceList, this.comparator);
        return Collections.unmodifiableList(gripperDeviceList);
    }

    private Comparator<GripperDevice> createComparator() {
        return new Comparator<GripperDevice>(){

            @Override
            public int compare(GripperDevice gripperDevice1, GripperDevice gripperDevice2) {
                return gripperDevice1.getContributorInfo().getName().compareTo(gripperDevice2.getContributorInfo().getName());
            }
        };
    }

    private boolean isGripperDevice(GripperDevice gripperDevice, String symbolicName, String deviceId) {
        return gripperDevice.getContributorInfo().getSymbolicName().equals(symbolicName) && this.getId(gripperDevice).equals(deviceId);
    }

    private boolean isGripperDevicePresent(Class<?> serviceClass, String deviceId) {
        URCapInfo urCapInfo = this.urCapServiceProvider.getURCapInfo(serviceClass);
        String urCapSymbolicName = urCapInfo.getSymbolicName();
        for (GripperDevice gripperDevice : this.deviceMap.keySet()) {
            if (!this.isGripperDevice(gripperDevice, urCapSymbolicName, deviceId)) continue;
            return true;
        }
        return false;
    }

    private String getId(GripperDevice gripperDevice) {
        if (gripperDevice instanceof Identifiable) {
            return ((Identifiable)gripperDevice).getId();
        }
        return gripperDevice.toString();
    }
}

