/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.toolbar;

import com.ur.polyscope.gripper.internal.gripper.GripperContext;
import com.ur.polyscope.gripper.internal.gripper.params.Actions;
import com.ur.polyscope.gripper.internal.gripper.params.GripperParam;
import com.ur.polyscope.gripper.internal.gripper.params.Operation;
import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadDataModel;
import com.ur.polyscope.gripper.internal.gripper.toolbar.ToolbarParams;
import com.ur.polyscope.payload.common.PayloadScriptGenerator;
import com.ur.urcap.api.contribution.driver.gripper.GripperContribution;
import com.ur.urcap.api.domain.payload.Payload;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.SelectableGripper;
import com.ur.urcap.api.domain.script.ScriptWriter;

public class ToolbarActions
extends Actions {
    private final ToolbarParams gripParameters;
    private final ToolbarParams releaseParameters;
    private final GripperContext context;
    private final GripperParam gripperParam;

    public ToolbarActions(GripperContribution gripperContribution, GripperContext context, GripperParam gripperParam) {
        super(gripperContribution);
        this.context = context;
        this.gripperParam = gripperParam;
        this.gripParameters = new ToolbarParams(context, Operation.GRIP, gripperParam);
        this.releaseParameters = new ToolbarParams(context, Operation.RELEASE, gripperParam);
    }

    @Override
    public void onGripButton() {
        if (this.checkRobotState()) {
            this.getScriptThread(this.gripParameters, Operation.GRIP, this.context.getGripPayload()).start();
        }
    }

    @Override
    public void onReleaseButton() {
        if (this.checkRobotState()) {
            this.getScriptThread(this.releaseParameters, Operation.RELEASE, this.context.getReleasePayload()).start();
        }
    }

    @Override
    public void onGripperSelected(SelectableGripper gripper) {
        this.gripperParam.setValue(gripper);
    }

    public SelectableGripper getGripperSelection() {
        return this.gripperParam.getValue();
    }

    protected Thread getScriptThread(final ToolbarParams toolbarParams, final Operation operation, final PayloadDataModel payloadDataModel) {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                Payload payload;
                ToolbarActions.this.sendStopProgramToController();
                ScriptWriter scriptWriter = ToolbarActions.this.generateScriptCode(toolbarParams, operation);
                if (payloadDataModel.isUsePayload() && (payload = payloadDataModel.getPayload()) instanceof PayloadScriptGenerator) {
                    com.ur.polyscope.scriptwriter.ScriptWriter writer = new com.ur.polyscope.scriptwriter.ScriptWriter();
                    ((PayloadScriptGenerator)payload).generatePayloadScript(writer);
                    scriptWriter.appendLine(writer.generateScript());
                }
                String script = scriptWriter.generateScript();
                ToolbarActions.this.sendScriptToController(script);
            }
        }, "scriptThread");
    }
}

