/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.toolbar;

import com.ur.polyscope.gripper.internal.gripper.GripperContext;
import com.ur.polyscope.gripper.internal.gripper.PropertyChanger;
import com.ur.polyscope.gripper.internal.gripper.common.widgets.NoGrippersMessagePanel;
import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadDataModel;
import com.ur.polyscope.gripper.internal.gripper.program.payload.PayloadPanel;
import com.ur.polyscope.gripper.internal.gripper.program.payload.ui.PayloadPanelImpl;
import com.ur.polyscope.gripper.internal.gripper.program.payload.ui.PayloadToolbarPanelImpl;
import com.ur.polyscope.gripper.internal.gripper.toolbar.ToolbarActions;
import com.ur.polyscope.gripper.internal.gripper.toolbar.ToolbarGripperComboBoxModel;
import com.ur.polyscope.gripper.resource.internal.TextResource;
import com.ur.polyscope.payload.PayloadModificationObserver;
import com.ur.polyscope.payload.PayloadObserver;
import com.ur.polyscope.payload.common.InstallationPayloadComponent;
import com.ur.polyscope.payload.common.PayloadComponent;
import com.ur.polyscope.payload.observers.ActivePayloadChanged;
import com.ur.polyscope.urcaps.URCapErrorPanel;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.ComboBox;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.urcap.api.domain.payload.Payload;
import com.ur.urcap.api.domain.program.nodes.contributable.device.gripper.configuration.SelectableGripper;
import com.ur.util.event.EventManager;
import com.ur.util.event.Subscription;
import com.ur.util.swing.HTML;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.inject.Inject;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ToolbarView {
    public static final String PERFORM_GRIP_ACTION_TOOLBAR = "performGripAction.toolbar";
    public static final String PERFORM_RELEASE_ACTION_TOOLBAR = "performReleaseAction.toolbar";
    public static final String SELECT_GRIPPER = "selectGripper.toolbar";
    public static final String GRIP = "grip";
    public static final String RELEASE = "release";
    public static final String NO_GRIPPERS = "NO-GRIPPERS";
    public static final String GRIPPERS = "GRIPPERS";
    public static final String SINGLE_GRIPPER_ENABLED = "just-text";
    public static final String MULTIPLE_GRIPPERS_ENABLED = "combo-box";
    private final ViewContext viewContext;
    private final TextResource textResource;
    private final PayloadPanelImpl gripPayloadPanel;
    private final PayloadPanelImpl releasePayloadPanel;
    private final EventManager eventManager;
    private Collection<Subscription> subscriptions;
    private GripperContext gripperContext;
    private ToolbarActions actions;
    private ToolbarGripperComboBoxModel gripperComboBoxModel;
    private ComboBox gripperComboBox;
    private JLabel singleEnabledGripperName;
    private JButton gripAction;
    private JButton releaseAction;
    private JPanel rootPanel;
    private JPanel mainPanel;
    private URCapErrorPanel errorPanel;
    private boolean open = false;

    @Inject
    public ToolbarView(ViewContext viewContext, PayloadToolbarPanelImpl gripPayloadPanel, PayloadToolbarPanelImpl releasePayloadPanel, EventManager eventManager) {
        this.viewContext = viewContext;
        this.gripPayloadPanel = gripPayloadPanel;
        this.gripPayloadPanel.setName(GRIP);
        this.releasePayloadPanel = releasePayloadPanel;
        this.releasePayloadPanel.setName(RELEASE);
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.eventManager = eventManager;
    }

    public void init(GripperContext gripperContext, ToolbarActions actions) {
        this.gripperContext = gripperContext;
        this.actions = actions;
    }

    public void buildUI(JPanel panel, String title) {
        Dimension panelSize = panel.getSize();
        this.rootPanel = panel;
        this.errorPanel = GripperContext.createErrorPanel();
        this.errorPanel.setPreferredSize(panelSize);
        this.createMainPanel(title);
    }

    public void onOpen() {
        PayloadObserverImpl payloadObserver = new PayloadObserverImpl();
        this.subscriptions = new ArrayList<Subscription>();
        this.subscriptions.add(this.eventManager.addStrongListener(PayloadObserver.class, (Object)payloadObserver));
        this.subscriptions.add(this.eventManager.addStrongListener(PayloadModificationObserver.class, (Object)payloadObserver));
        this.subscriptions.add(this.eventManager.addStrongListener(ActivePayloadChanged.class, (Object)payloadObserver));
    }

    private void createMainPanel(String title) {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new CardLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder());
        Dimension size = this.rootPanel.getMaximumSize();
        this.mainPanel.setMaximumSize(size);
        this.mainPanel.setPreferredSize(size);
        WidgetFactory widgetFactory = this.viewContext.createWidgetFactory();
        this.mainPanel.add((Component)this.viewContext.createFormBuilder().headerLabel(title, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS, FormBuilder.PanelConstraints.CENTER}).end(2).component((JComponent)new NoGrippersMessagePanel(this.textResource, title), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS, FormBuilder.PanelConstraints.SPAN_9_ROWS}).end(9).getPanel(), NO_GRIPPERS);
        FormBuilder formBuilder = this.viewContext.createFormBuilder();
        this.gripAction = widgetFactory.createButton((Action)((Object)new PerformGripAction(this.textResource, this.actions)));
        this.releaseAction = widgetFactory.createButton((Action)((Object)new PerformReleaseAction(this.textResource, this.actions)));
        this.createTitle(formBuilder, title);
        this.createGripperSection(formBuilder, widgetFactory);
        this.createActionSection(formBuilder, this.gripAction, this.gripPayloadPanel, new GripListener());
        this.createSeparator(widgetFactory, formBuilder);
        this.createActionSection(formBuilder, this.releaseAction, this.releasePayloadPanel, new ReleaseListener());
        this.mainPanel.add((Component)formBuilder.getPanel(), GRIPPERS);
    }

    private void createTitle(FormBuilder formBuilder, String title) {
        formBuilder.headerLabel(title, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS, FormBuilder.PanelConstraints.CENTER}).end(2);
    }

    private void createGripperSection(FormBuilder formBuilder, WidgetFactory widgetFactory) {
        if (!this.gripperContext.isMultiGripper()) {
            return;
        }
        for (SelectableGripper each : this.gripperContext.getGrippers()) {
            this.addListener(each);
        }
        this.gripperComboBox = widgetFactory.createComboBox();
        this.gripperComboBoxModel = new ToolbarGripperComboBoxModel(this.textResource, this.gripperContext);
        this.gripperComboBox.setModel((ComboBoxModel)this.gripperComboBoxModel);
        this.gripperComboBox.addItemListener((ItemListener)new GripperItemListener((JComboBox)this.gripperComboBox, this.actions, this));
        this.gripperComboBox.setName(SELECT_GRIPPER);
        JPanel gripperSelection = this.createGripperSelectionPanel(widgetFactory);
        String gripperSelectionHeaderText = HTML.fontBold((String)this.textResource.gripper());
        formBuilder.spacer(2).label(gripperSelectionHeaderText, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end();
        formBuilder.spacer(2).component((JComponent)gripperSelection, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end();
        this.createSeparator(widgetFactory, formBuilder);
    }

    private JPanel createGripperSelectionPanel(WidgetFactory widgetFactory) {
        JPanel gripperSelection = new JPanel(new CardLayout());
        gripperSelection.setBorder(BorderFactory.createEmptyBorder());
        this.singleEnabledGripperName = widgetFactory.createLabel("");
        this.singleEnabledGripperName.setBorder(BorderFactory.createEtchedBorder());
        this.singleEnabledGripperName.setVisible(false);
        gripperSelection.add((Component)this.singleEnabledGripperName, SINGLE_GRIPPER_ENABLED);
        gripperSelection.add((Component)this.gripperComboBox, MULTIPLE_GRIPPERS_ENABLED);
        return gripperSelection;
    }

    private void addListener(SelectableGripper each) {
        if (each instanceof PropertyChanger) {
            ((PropertyChanger)each).addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ToolbarView.this.initialize();
                }
            });
        }
    }

    private void createActionSection(FormBuilder formBuilder, JButton action, PayloadPanelImpl payload, PayloadPanel.PayloadPanelListener listener) {
        payload.setModifyListener(listener);
        payload.layoutToolbar(formBuilder);
        formBuilder.spacer(2).component((JComponent)action, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS, FormBuilder.PanelConstraints.BUTTON_ROW}).spacer(2).end();
    }

    private void createSeparator(WidgetFactory widgetFactory, FormBuilder formBuilder) {
        formBuilder.end();
        formBuilder.component(widgetFactory.createSeparator(G5LookAndFeel.BETWEEN_CARD_COLOR), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS});
        formBuilder.end();
    }

    public void initialize() {
        if (this.gripperContext.hasInitializationException()) {
            this.initializeErrorPanel();
        } else {
            this.initializeMainPanel();
        }
        this.open = true;
    }

    private void initializeErrorPanel() {
        this.rootPanel.removeAll();
        this.rootPanel.add((Component)this.errorPanel);
        this.errorPanel.setStackTrace(this.gripperContext.getInitializationExceptionStackTrace());
        this.errorPanel.setMetadataFromClass(this.gripperContext.getContributionClass());
    }

    public void initializeMainPanel() {
        this.rootPanel.removeAll();
        this.rootPanel.add(this.mainPanel);
        boolean hasGripper = !this.gripperContext.isMultiGripper() || !this.gripperContext.getGrippersEnabled().isEmpty();
        CardLayout cardLayout = (CardLayout)this.mainPanel.getLayout();
        cardLayout.show(this.mainPanel, hasGripper ? GRIPPERS : NO_GRIPPERS);
        this.initializeMultiGripperComboBox();
        this.initializeButtons();
    }

    private void initializeButtons() {
        if (this.gripAction == null || this.releaseAction == null) {
            return;
        }
        boolean isValid = this.isValidGripperSelected();
        boolean isValidGripPayload = this.gripperContext.getGripPayload().isPayloadValid();
        boolean isValidReleasePayload = this.gripperContext.getReleasePayload().isPayloadValid();
        PayloadDataModel gripPayload = this.gripperContext.getGripPayload();
        this.gripPayloadPanel.update(true, gripPayload.isUsePayload(), gripPayload.getPayload());
        PayloadDataModel releasePayload = this.gripperContext.getReleasePayload();
        this.releasePayloadPanel.update(true, releasePayload.isUsePayload(), releasePayload.getPayload());
        this.gripAction.setEnabled(isValid && isValidGripPayload);
        this.releaseAction.setEnabled(isValid && isValidReleasePayload);
    }

    private boolean isValidGripperSelected() {
        if (!this.gripperContext.isMultiGripper()) {
            return true;
        }
        return !this.gripperContext.getGrippersEnabled().isEmpty();
    }

    private void initializeMultiGripperComboBox() {
        if (!this.gripperContext.isMultiGripper()) {
            return;
        }
        this.gripperComboBoxModel.reloadElements(this.actions.getGripperSelection());
        boolean isSingleGripper = this.gripperContext.getGrippersEnabled().size() == 1;
        this.singleEnabledGripperName.setVisible(isSingleGripper);
        this.gripperComboBox.setVisible(!isSingleGripper);
        this.singleEnabledGripperName.setText(this.gripperComboBox.getSelectedItem().toString());
    }

    public void close() {
        this.gripPayloadPanel.close();
        this.releasePayloadPanel.close();
        for (Subscription s : this.subscriptions) {
            s.dispose();
        }
        this.open = false;
    }

    private class GripListener
    implements PayloadPanel.PayloadPanelListener {
        private GripListener() {
        }

        @Override
        public void onPayloadModified(boolean usePayload, Payload payload) {
            PayloadDataModel dataModel = ToolbarView.this.gripperContext.getGripPayload();
            dataModel.setUsePayload(usePayload);
            dataModel.setPayload(payload);
            ToolbarView.this.initializeButtons();
        }
    }

    private static class GripperItemListener
    implements ItemListener {
        private final JComboBox gripperComboBox;
        private final ToolbarActions toolbarActions;
        private final ToolbarView view;

        public GripperItemListener(JComboBox gripperComboBox, ToolbarActions toolbarActions, ToolbarView view) {
            this.gripperComboBox = gripperComboBox;
            this.toolbarActions = toolbarActions;
            this.view = view;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                Object selectedItem = this.gripperComboBox.getSelectedItem();
                SelectableGripper selectedGripper = selectedItem instanceof SelectableGripper ? (SelectableGripper)selectedItem : null;
                this.toolbarActions.onGripperSelected(selectedGripper);
                this.view.initializeButtons();
            }
        }
    }

    class PayloadObserverImpl
    implements PayloadObserver,
    PayloadModificationObserver,
    ActivePayloadChanged {
        PayloadObserverImpl() {
        }

        public void added(InstallationPayloadComponent payload) {
            if (ToolbarView.this.open) {
                ToolbarView.this.initialize();
            }
        }

        public void removed(InstallationPayloadComponent payload) {
            if (ToolbarView.this.open) {
                ToolbarView.this.initialize();
            }
        }

        public void nameChanged(InstallationPayloadComponent installationPayloadComponent, String s, String s1) {
            if (ToolbarView.this.open) {
                ToolbarView.this.initialize();
            }
        }

        public void modified(InstallationPayloadComponent payload) {
            if (ToolbarView.this.open) {
                ToolbarView.this.initialize();
            }
        }

        public void activePayloadChanged(PayloadComponent previouslyActive, PayloadComponent currentlyActive) {
            if (ToolbarView.this.open) {
                ToolbarView.this.initialize();
            }
        }
    }

    private static final class PerformGripAction
    extends AbstractActionDefinition {
        private final transient ToolbarActions actions;

        public PerformGripAction(TextResource textResource, ToolbarActions actions) {
            this.actions = actions;
            this.putValue("Name", textResource.grip());
            this.putValue("InternalName", ToolbarView.PERFORM_GRIP_ACTION_TOOLBAR);
            this.putValue("Function", ActionDefinition.Function.SECONDARY);
        }

        public void actionPerformed(ActionEvent e) {
            this.actions.onGripButton();
        }
    }

    private static final class PerformReleaseAction
    extends AbstractActionDefinition {
        private final transient ToolbarActions actions;

        public PerformReleaseAction(TextResource textResource, ToolbarActions actions) {
            this.actions = actions;
            this.putValue("Name", textResource.release());
            this.putValue("InternalName", ToolbarView.PERFORM_RELEASE_ACTION_TOOLBAR);
            this.putValue("Function", ActionDefinition.Function.SECONDARY);
        }

        public void actionPerformed(ActionEvent e) {
            this.actions.onReleaseButton();
        }
    }

    private class ReleaseListener
    implements PayloadPanel.PayloadPanelListener {
        private ReleaseListener() {
        }

        @Override
        public void onPayloadModified(boolean usePayload, Payload payload) {
            PayloadDataModel dataModel = ToolbarView.this.gripperContext.getReleasePayload();
            dataModel.setUsePayload(usePayload);
            dataModel.setPayload(payload);
            ToolbarView.this.initializeButtons();
        }
    }
}

