/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.gripper.internal.gripper.util;

import com.ur.polyscope.payload.common.PayloadValidationRules;
import com.ur.polyscope.urcaps.util.OptionalImpl;
import com.ur.urcap.api.domain.payload.IllegalMassException;
import com.ur.urcap.api.domain.value.simple.Mass;
import com.ur.urcap.api.util.Optional;

public final class ArgumentValidationHelper {
    private ArgumentValidationHelper() {
    }

    public static <T> void throwIfNotInternalImplementation(Optional<T> optional) {
        if (!(optional instanceof OptionalImpl)) {
            throw new IllegalArgumentException("Illegal 'Optional': Only 'Optional' taken from an existing config is allowed. For instance, use 'GripActionConfig.getGripperSelection()'");
        }
    }

    public static void throwIfNotValidMass(Mass mass, PayloadValidationRules payloadValidationRules) {
        if (payloadValidationRules.isMassBelowZeroHardLimit(mass) || payloadValidationRules.isMassAboveUpperHardLimit(mass)) {
            throw new IllegalMassException(payloadValidationRules.getMassOutOfHardLimitsExceptionMessage(mass));
        }
    }
}

