/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.safety;

import com.ur.bean.PropertyChangeSite;
import com.ur.bean.URPropertyChangeSupport;
import com.ur.lang.EqualsBuilder;
import com.ur.lang.HashCodeBuilder;
import com.ur.lang.PrimitiveUtils;
import com.ur.monitor.RobotState;
import com.ur.polyscope.installation.InstallationComponent;
import com.ur.polyscope.persistence.Options;
import com.ur.polyscope.persistence.OptionsSection;
import com.ur.polyscope.persistence.Persistable;
import com.ur.polyscope.safety.ComponentContainer;
import com.ur.polyscope.safety.SafetySetupComponent;
import com.ur.polyscope.safety.SafetySetupContribution;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import com.ur.polyscope.safety.checksum.VersionComponent;
import com.ur.polyscope.safety.version.SafetyControlBoardVersionSite;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Set;
import javax.inject.Inject;

public class SafetySetup
implements InstallationComponent,
Persistable,
PropertyChangeSite {
    public static final double EQUALS_PRECISION = 1.0E-5;
    public static final int HASH_CODE_PRECISION = PrimitiveUtils.getDecimals((double)1.0E-5);
    public static final String SAFETY_CRC_VERSION_KEY = "version";
    public static final String SAFETY_CHECKSUM_SECTION = "Safety Checksum";
    public static final String SAFETY_CRC_KEY = "crc";
    private final transient URPropertyChangeSupport changeSupport;
    private final transient SafetyControlBoardVersionSite versionSite;
    private final ComponentContainer components;

    @Inject
    public SafetySetup(SafetyControlBoardVersionSite versionSite, Set<SafetySetupContribution> contributions) {
        this.versionSite = versionSite;
        this.changeSupport = new URPropertyChangeSupport((Object)this);
        this.components = new ComponentContainer();
        new HashMap();
        for (SafetySetupContribution each : contributions) {
            this.components.add(each, each.createDefaultComponent());
        }
    }

    public static boolean isReducedModeEnabled() {
        return RobotState.getLatestRobotState().reducedModeActive;
    }

    public Class<?> getType() {
        return SafetySetup.class;
    }

    public <T extends SafetySetupComponent> T getComponent(Class<T> type) {
        return (T)((SafetySetupComponent)this.components.getComponent(type));
    }

    @Deprecated
    public <T extends SafetySetupComponent> void setComponent(Class<T> type, T component) {
        this.components.set(type, component);
    }

    public String writeAsString() {
        return this.toString();
    }

    public boolean isReducedModeDefined() {
        for (SafetySetupComponent each : this.components.components()) {
            if (!each.isReducedModeDefined()) continue;
            return true;
        }
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
        for (SafetySetupComponent each : this.components.components()) {
            each.addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
        for (SafetySetupComponent each : this.components.components()) {
            each.removePropertyChangeListener(listener);
        }
    }

    public void fireEvent(PropertyChangeEvent evt) {
        this.changeSupport.firePropertyChange(evt);
    }

    public void copyTo(Options options) {
        VersionComponent versionComponent = this.components.getComponent(VersionComponent.class);
        for (Class<? extends SafetySetupComponent> each : this.components.componentTypes()) {
            this.copyComponentTo(each, options, versionComponent.getChecksumVersion());
        }
    }

    private <T extends SafetySetupComponent> void copyComponentTo(Class<T> componentType, Options options, ChecksumVersion checksumVersion) {
        SafetySetupComponent component = (SafetySetupComponent)this.components.getComponent(componentType);
        SafetySetupContribution<SafetySetupComponent> contribution = this.components.getContribution(componentType);
        if (contribution.isSupported(checksumVersion)) {
            contribution.copyToOptions(checksumVersion, options, component);
        }
    }

    public void readFrom(Options options) {
        OptionsSection safetyChecksumProperties = options.getSection(SAFETY_CHECKSUM_SECTION);
        ChecksumVersion defaultChecksumVersion = this.versionSite.getSafetyFeatureSupport().latestChecksum();
        ChecksumVersion version = ChecksumVersion.fromString(safetyChecksumProperties.getString(SAFETY_CRC_VERSION_KEY, defaultChecksumVersion.toString()));
        for (Class<? extends SafetySetupComponent> each : this.components.componentTypes()) {
            this.readComponentFrom(each, options, version);
        }
    }

    private <T extends SafetySetupComponent> void readComponentFrom(Class<T> componentType, Options options, ChecksumVersion version) {
        SafetySetupContribution<T> contribution = this.components.getContribution(componentType);
        T newComponent = contribution.readFromOptions(version, options);
        this.components.add(contribution, newComponent);
    }

    public int hashCode() {
        return new HashCodeBuilder(HASH_CODE_PRECISION).reflectHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return new EqualsBuilder(1.0E-5).isEquals((Object)this, obj);
    }

    public String toString() {
        Options options = new Options();
        VersionComponent versionComponent = this.components.getComponent(VersionComponent.class);
        for (Class<? extends SafetySetupComponent> each : this.components.componentTypes()) {
            this.copyControllerRepresentationTo(each, options, versionComponent.getChecksumVersion());
        }
        StringWriter optionsString = new StringWriter();
        options.save((Writer)optionsString);
        String s = "# Beware: This file is auto-generated from PolyScope.\n# NOTE: The SafetyParameters section is protected by a CRC checksum, please use the supplied tool\n\n## SafetyParameters ##\n" + optionsString.toString() + "\n## SafetyParameters ##\n";
        return s;
    }

    private <T extends SafetySetupComponent> void copyControllerRepresentationTo(Class<T> componentType, Options options, ChecksumVersion checksumVersion) {
        SafetySetupComponent component = (SafetySetupComponent)this.components.getComponent(componentType);
        SafetySetupContribution<SafetySetupComponent> contribution = this.components.getContribution(componentType);
        if (contribution.isSupported(checksumVersion)) {
            contribution.copyControllerRepresentationTo(checksumVersion, options, component);
        }
    }

    public boolean completelyEquals(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        SafetySetup other = (SafetySetup)obj;
        for (Class<? extends SafetySetupComponent> each : this.components.componentTypes()) {
            SafetySetupComponent otherComponent;
            SafetySetupComponent component = this.components.getComponent(each);
            if (component.completelyEquals(otherComponent = other.components.getComponent(each))) continue;
            return false;
        }
        return true;
    }
}

