/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.safety.checksum;

import com.ur.util.SimpleVersion;
import java.util.Arrays;
import java.util.Optional;

public enum ChecksumVersion implements SimpleVersion
{
    NULL(0, 0),
    VERSION_1_0(1, 0),
    VERSION_3_1(3, 1),
    VERSION_3_2(3, 2),
    VERSION_5_0(5, 0),
    VERSION_5_2(5, 2),
    VERSION_5_3(5, 3),
    VERSION_5_4(5, 4),
    VERSION_5_5(5, 5),
    VERSION_5_6(5, 6),
    VERSION_5_7(5, 7),
    VERSION_5_8(5, 8),
    VERSION_5_9(5, 9),
    VERSION_5_10(5, 10),
    VERSION_5_11(5, 11);

    private final int major;
    private final int minor;

    private ChecksumVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public String toString() {
        return this.major + "." + this.minor;
    }

    public boolean atLeast(ChecksumVersion other) {
        return this.major >= other.major && (this.major > other.major || this.minor >= other.minor);
    }

    public boolean before(ChecksumVersion other) {
        return !this.atLeast(other);
    }

    public static ChecksumVersion fromString(String versionString) {
        return (ChecksumVersion)SimpleVersion.Parser.parseVersionString((String)versionString, (SimpleVersion[])ChecksumVersion.values());
    }

    public static Optional<ChecksumVersion> fromMajorMinor(int major, int minor) {
        return Arrays.stream(ChecksumVersion.values()).filter(checksumVersion -> checksumVersion.major == major).filter(checksumVersion -> checksumVersion.minor == minor).findFirst();
    }
}

