/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.safety.checksum;

import com.ur.lang.StringUtils;
import com.ur.polyscope.persistence.Options;
import com.ur.polyscope.safety.SafetySetupComponent;
import com.ur.polyscope.safety.checksum.ChecksumVersion;
import java.beans.PropertyChangeListener;

public class VersionComponent
implements SafetySetupComponent {
    private transient ChecksumVersion checksumVersion;
    private transient boolean verifiedState;
    private transient boolean checksumVersionSpecified = false;
    private transient String loadedCRCValue;
    public static final ChecksumVersion FIRST_G5_VERSION = ChecksumVersion.VERSION_5_0;
    public static final ChecksumVersion LATEST_VERSION = ChecksumVersion.VERSION_5_11;

    public VersionComponent(ChecksumVersion checksumVersion, boolean checksumVersionSpecified) {
        this.checksumVersion = checksumVersion;
        this.checksumVersionSpecified = checksumVersionSpecified;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public boolean isReducedModeDefined() {
        return false;
    }

    public void setVerified(boolean verifiedState) {
        this.verifiedState = verifiedState;
    }

    public void setVerified(Options options) {
        this.setVerified(options.getSection("SafetySetup").getBoolean("verified", Boolean.valueOf(false)));
    }

    public boolean isVerified() {
        return this.verifiedState;
    }

    public void setChecksumVersion(ChecksumVersion version) {
        this.checksumVersionSpecified = true;
        this.checksumVersion = version;
    }

    public boolean isCheckSumVersionSpecified() {
        return this.checksumVersionSpecified;
    }

    public ChecksumVersion getChecksumVersion() {
        return this.checksumVersion;
    }

    public void setCRCValue(String newCRCValue) {
        this.loadedCRCValue = newCRCValue;
    }

    public String getLoadedCRCValue() {
        if (StringUtils.isNullOrOnlyWhitespace((String)this.loadedCRCValue)) {
            this.loadedCRCValue = "";
        }
        return this.loadedCRCValue;
    }

    @Override
    public boolean completelyEquals(Object other) {
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        return true;
    }

    public String toString() {
        return "Verified: " + this.verifiedState + ", Checksum Version: " + (Object)((Object)this.checksumVersion);
    }
}

