/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl;

import com.ur.polyscope.system.ShutdownListener;
import com.ur.polyscope.system.ShutdownService;
import com.ur.polyscope.system.impl.ImageResource;
import com.ur.polyscope.system.impl.TextResource;
import com.ur.swing.CardPanel;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.util.event.EventManager;
import com.ur.util.event.Subscription;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

public abstract class ApplyAndRestartPanel
extends CardPanel {
    private final ShutdownService shutdownService;
    private final EventManager eventManager;
    public JButton restartNowButton;
    private Subscription shutdownSubscibtion;

    public ApplyAndRestartPanel(ShutdownService shutdownService, EventManager eventManager) {
        this.shutdownService = shutdownService;
        this.eventManager = eventManager;
    }

    public void enter(Object o) {
        super.enter(o);
        this.addShutdownHook();
    }

    public Object exit() {
        this.removeShutdownHook();
        return super.exit();
    }

    private void addShutdownHook() {
        this.removeShutdownHook();
        this.shutdownSubscibtion = this.eventManager.addStrongListener(ShutdownListener.class, (Object)new ShutdownListener(){

            public void shutdownStarted() {
                ApplyAndRestartPanel.this.applySettingsPerformed();
            }

            public void restartStarted() {
                ApplyAndRestartPanel.this.applySettingsPerformed();
            }
        });
    }

    private void removeShutdownHook() {
        if (this.shutdownSubscibtion == null) {
            return;
        }
        this.shutdownSubscibtion.dispose();
        this.shutdownSubscibtion = null;
    }

    public JPanel createRestartPanel(ViewContext viewContext) {
        WidgetFactory widgetFactory = viewContext.createWidgetFactory();
        final TextResource textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.restartNowButton = new JButton();
        this.restartNowButton.setAction(new AbstractAction(){
            {
                this.putValue("SmallIcon", ImageResource.blank1x24());
                this.putValue("Name", textResource.applyAndRestart());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplyAndRestartPanel.this.shutdownService.requestShutdown();
            }
        });
        widgetFactory.createButtonFunction((AbstractButton)this.restartNowButton);
        JPanel result = new JPanel(new BorderLayout());
        result.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        result.add((Component)this.restartNowButton, "East");
        return result;
    }

    protected void createApplyAndRestartButton(TextResource textResource) {
        this.restartNowButton = new JButton();
        this.restartNowButton.setText(textResource.restartNow());
        this.restartNowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ApplyAndRestartPanel.this.shutdownService.requestShutdown();
            }
        });
    }

    protected abstract void applySettingsPerformed();
}

