/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl;

import com.ur.lang.resources.Key;
import com.ur.util.logging.Log;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class ImageResource {
    private static boolean isG5 = true;

    private ImageResource() {
    }

    private static Icon tryGetImage(String fileName) {
        if (isG5) {
            return ImageLoader.getIconImage("/images/icons/", fileName);
        }
        return ImageLoader.getIconImage("<g3ImagesDir>", fileName);
    }

    @Key(value="form-warning.png")
    public static Icon formWarning() {
        return ImageResource.tryGetImage("form-warning.png");
    }

    @Key(value="metal-question.png")
    public static Icon metalQuestion() {
        return ImageResource.tryGetImage("metal-question.png");
    }

    @Key(value="power-white.png")
    public static Icon powerWhite() {
        return ImageResource.tryGetImage("power-white.png");
    }

    @Key(value="blank_1x24.png")
    public static Icon blank1x24() {
        return ImageResource.tryGetImage("blank_1x24.png");
    }

    @Key(value="gtk-cancel.png")
    public static Icon gtkCancel() {
        return ImageResource.tryGetImage("gtk-cancel.png");
    }

    @Key(value="power-black.png")
    public static Icon powerBlack() {
        return ImageResource.tryGetImage("power-black.png");
    }

    @Key(value="form-information.png")
    public static Icon formInformation() {
        return ImageResource.tryGetImage("form-information.png");
    }

    @Key(value="gtk-ok.png")
    public static Icon gtkOk() {
        return ImageResource.tryGetImage("gtk-ok.png");
    }

    public static URL asResource(Icon iconFromImageResource) {
        return ImageResource.class.getResource(((ImageIcon)iconFromImageResource).getDescription());
    }

    static {
        if (isG5) {
            ImageResource.tryGetImage("form-warning.png");
            ImageResource.tryGetImage("metal-question.png");
            ImageResource.tryGetImage("power-white.png");
            ImageResource.tryGetImage("blank_1x24.png");
            ImageResource.tryGetImage("gtk-cancel.png");
            ImageResource.tryGetImage("power-black.png");
            ImageResource.tryGetImage("form-information.png");
            ImageResource.tryGetImage("gtk-ok.png");
        }
    }

    private static final class ImageLoader {
        private static final HashMap<String, Icon> cachedIconResources = new HashMap();

        private ImageLoader() {
        }

        static Icon getIconImage(String path, String resource) {
            if (!cachedIconResources.containsKey(resource)) {
                String resourcePath = path + resource;
                cachedIconResources.put(resource, new ImageIconWrapper(resourcePath, ImageLoader.tryToLoadImage(resourcePath)));
            }
            return cachedIconResources.get(resource);
        }

        private static BufferedImage tryToLoadImage(String resource) {
            try {
                return ImageIO.read(ImageLoader.class.getResource(resource));
            }
            catch (IOException e1) {
                Log.warning((String)"Failed to load image as bundle resource", (Throwable)e1);
                try {
                    return ImageIO.read(new File(resource));
                }
                catch (IOException e2) {
                    Log.warning((String)("Failed to load image as file '" + resource + "'."), (Throwable)e2);
                    return null;
                }
            }
        }

        private static class ImageIconWrapper
        extends ImageIcon {
            private final String name;
            private final String fullName;

            ImageIconWrapper(String fullPathToResource, BufferedImage image) {
                super(image);
                this.name = fullPathToResource.substring(fullPathToResource.lastIndexOf(47) + 1);
                this.fullName = fullPathToResource;
            }

            @Override
            public String getDescription() {
                return this.fullName;
            }

            @Override
            public String toString() {
                return "ImageIcon '" + this.name + "'";
            }
        }
    }
}

