/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.system.impl;

import com.ur.injection.Binder;
import com.ur.injection.Builder;
import com.ur.injection.ServicesBinder;
import com.ur.log.logentry.robotmessage.RobotMessageConsumer;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.robot.configuration.robotidentification.RobotIdentification;
import com.ur.polyscope.robot.configuration.robotidentification.SerialNumberListener;
import com.ur.polyscope.system.ShutdownListener;
import com.ur.polyscope.system.ShutdownService;
import com.ur.polyscope.system.impl.Settings;
import com.ur.polyscope.system.impl.TextResource;
import com.ur.polyscope.system.impl.backuprestore.BackupRestoreActionPanelDefinition;
import com.ur.polyscope.system.impl.firmwareupdate.FirmwareUpdateMessageConsumer;
import com.ur.polyscope.system.impl.firmwareupdate.FirmwareUpdateNotifier;
import com.ur.polyscope.system.impl.impl.TextResourceImpl;
import com.ur.polyscope.system.impl.internal.ShutdownAction;
import com.ur.polyscope.system.impl.internal.ShutdownMenuExtension;
import com.ur.polyscope.system.impl.internal.ShutdownServiceImpl;
import com.ur.polyscope.system.impl.language.ChinaForChina;
import com.ur.polyscope.system.impl.language.LanguageActionPanelDefinition;
import com.ur.polyscope.system.impl.language.LanguageSelectLayoutStrategy;
import com.ur.polyscope.system.impl.language.LanguageSelectPanel;
import com.ur.polyscope.system.impl.network.internal.DisplayHostNameExtension;
import com.ur.polyscope.system.impl.network.internal.DisplayIPAddressExtension;
import com.ur.polyscope.system.impl.network.internal.NetworkActionPanelDefinition;
import com.ur.polyscope.system.impl.network.internal.NetworkingService;
import com.ur.polyscope.system.impl.network.internal.NetworkingServiceNetStatistics;
import com.ur.polyscope.system.impl.network.internal.SimulatedNetworkingService;
import com.ur.polyscope.system.impl.softwareupdate.SoftwareUpdateActionPanelDefinition;
import com.ur.polyscope.system.impl.softwareupdate.UpdatePanel;
import com.ur.polyscope.system.impl.softwareupdate.VersionComplianceChecker;
import com.ur.polyscope.system.impl.softwareupdate.VersionComplianceCheckerImpl;
import com.ur.polyscope.system.impl.time.SetTimeLayoutStrategy;
import com.ur.polyscope.system.impl.time.SetTimePanel;
import com.ur.polyscope.system.impl.time.TimeActionPanelDefinition;
import com.ur.swing.CardPanel;
import com.ur.swing.CardPanelMappedContribution;
import com.ur.swing.ShowScreenActionImpl;
import com.ur.swing.extensible.MenuExtension;
import com.ur.swing.extensible.VerticalPlacementExtension;
import com.ur.swing.platform.ActionPanelDefinition;
import com.ur.swing.platform.SetupSite;
import com.ur.util.event.EventManager;
import com.ur.view.constants.comm.RobotMessageType;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Provider;

public class ServiceBinderImpl
implements ServicesBinder {
    private static final String MOCK_CYBERSECURITY_BACKEND_PROPERTY = "mockCybersecurityBackend";

    public void bind(Binder binder) {
        Settings.setupIsUsingEnglishProgramming();
        binder.bindClass(TextResource.class, TextResourceImpl.class);
        binder.bindClass(ShutdownService.class, ShutdownServiceImpl.class);
        binder.bindKeyToExtensionPoint((Enum)RobotMessageType.FIRMWARE_UPDATE_STATUS, RobotMessageConsumer.class, FirmwareUpdateMessageConsumer.class);
        binder.bindToExtensionPoint(VerticalPlacementExtension.class, DisplayHostNameExtension.class);
        binder.bindToExtensionPoint(VerticalPlacementExtension.class, DisplayIPAddressExtension.class);
        binder.bindClass(ShowScreenActionImpl.class, ShutdownAction.class);
        binder.bindToExtensionPoint(MenuExtension.class, ShutdownMenuExtension.class);
        this.bindNetworkingService(binder);
        binder.bindClass(VersionComplianceChecker.class, VersionComplianceCheckerImpl.class);
        binder.bindClass(LanguageSelectPanel.LayoutStrategy.class, LanguageSelectLayoutStrategy.class);
        binder.bindClass(SetTimePanel.LayoutStrategy.class, SetTimeLayoutStrategy.class);
        binder.bindToExtensionPoint(ActionPanelDefinition.class, SoftwareUpdateActionPanelDefinition.class);
        binder.bindToExtensionPoint(CardPanelMappedContribution.class, (Object)new SystemCardPanelMappedContribution());
        binder.bindToExtensionPoint(SerialNumberListener.class, s -> new ChinaForChina((Provider<RobotIdentification>)((Provider)() -> s)).validateLanguageSelectionOnSerialNumber(Settings.getLanguage(), Settings.getKeyboardLayouts()));
    }

    private void bindNetworkingService(Binder binder) {
        if (Boolean.parseBoolean(System.getProperty(MOCK_CYBERSECURITY_BACKEND_PROPERTY, "false"))) {
            binder.bindClass(NetworkingService.class, SimulatedNetworkingService.class);
        } else {
            binder.bindClass(NetworkingService.class, NetworkingServiceNetStatistics.class);
        }
    }

    public void load(final Builder builder) {
        builder.get(FirmwareUpdateNotifier.class);
        ((SetupSite)builder.get(SetupSite.class)).addActionForPanel((ActionPanelDefinition)builder.get(NetworkActionPanelDefinition.class));
        ((SetupSite)builder.get(SetupSite.class)).addActionForPanel((ActionPanelDefinition)builder.get(LanguageActionPanelDefinition.class));
        ((SetupSite)builder.get(SetupSite.class)).addActionForPanel((ActionPanelDefinition)builder.get(TimeActionPanelDefinition.class));
        ((SetupSite)builder.get(SetupSite.class)).addActionForPanel((ActionPanelDefinition)builder.get(SoftwareUpdateActionPanelDefinition.class));
        ((SetupSite)builder.get(SetupSite.class)).addActionForPanel((ActionPanelDefinition)builder.get(BackupRestoreActionPanelDefinition.class));
        ((EventManager)builder.get(EventManager.class)).addStrongListener(ShutdownListener.class, (Object)new ShutdownListener(){

            public void restartStarted() {
                ((ControllerInterface)builder.get(ControllerInterface.class)).runScript("stop program\n");
            }

            public void shutdownStarted() {
                ((ControllerInterface)builder.get(ControllerInterface.class)).runScript("power off\n");
            }
        });
        ((ChinaForChina)builder.get(ChinaForChina.class)).validateLanguageSelectionOnLoad(Settings.getLanguage(), Settings.getKeyboardLayouts());
    }

    private static class SystemCardPanelMappedContribution
    implements CardPanelMappedContribution {
        private SystemCardPanelMappedContribution() {
        }

        public Map<Class<? extends CardPanel>, Class<? extends CardPanel>> mappedContribution() {
            HashMap<Class<? extends CardPanel>, Class<? extends CardPanel>> result = new HashMap<Class<? extends CardPanel>, Class<? extends CardPanel>>();
            result.put(UpdatePanel.class, UpdatePanel.class);
            return result;
        }
    }
}

